/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettingsConfigurable;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerSettings
extends XDebuggerSettings<CidrDebuggerSettings> {
    public boolean RENDERERS_ENABLED = true;
    public boolean VALUES_FILTER_ENABLED = true;
    public boolean COCOA_RENDERERS_ENABLED = true;
    public boolean CORE_DATA_RENDERERS_ENABLED = true;
    public boolean STL_RENDERERS_ENABLED = true;

    @NotNull
    public static CidrDebuggerSettings getInstance() {
        return (CidrDebuggerSettings)CidrDebuggerSettings.getInstance(CidrDebuggerSettings.class);
    }

    public CidrDebuggerSettings() {
        super("ObjectiveC");
    }

    public static void updateCurrentDebugSession(AnActionEvent e) {
        XDebugSession session = XDebuggerManager.getInstance((Project)AnAction.getEventProject((AnActionEvent)e)).getCurrentSession();
        if (session != null) {
            session.rebuildViews();
        }
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (PlatformUtils.isCidr()) {
            switch (category) {
                case DATA_VIEWS: {
                    return Collections.singletonList(new CidrDebuggerSettingsConfigurable(this));
                }
            }
        }
        return Collections.emptyList();
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        return PlatformUtils.isCidr() && "Objective-C".equals(configurable.getDisplayName());
    }

    public CidrDebuggerSettings getState() {
        return this;
    }

    public void loadState(CidrDebuggerSettings state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }
}

