/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePath) {
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            return new File(new File(PathManager.getHomePath(), "CIDR/cidr-debugger/bin/LLDB/" + selector), relativePath);
        }
        return new File(PathManager.getBinPath(), relativePath);
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        if (CidrDebuggerPathManager.isFromSources()) {
            return new File(PathManager.getHomePath(), "CIDR/cidr-debugger/bin/LLDB/shared/stl_printers");
        }
        return new File(PathManager.getBinPath(), "stl_printers");
    }

    @Nullable
    public static File getSystemPythonBinDir() {
        File pythonBinDir = new File("/System/Library/Frameworks/Python.framework/Versions/Current/bin");
        if (pythonBinDir.exists() && pythonBinDir.isDirectory()) {
            return pythonBinDir;
        }
        return null;
    }

    @NotNull
    public static File getBundledGDBBinary() {
        String gdbExeSubPath;
        String string = gdbExeSubPath = SystemInfo.isWindows ? "gdb.exe" : "gdb";
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector = SystemInfo.isWindows ? "bin_win/" : (SystemInfo.isMac ? "bin_mac/" : "bin_linux/");
            return new File(PathManager.getHomePath(), "CIDR/clion/bin/gdb/" + selector + gdbExeSubPath);
        }
        return new File(PathManager.getBinPath(), "gdb/bin/" + gdbExeSubPath);
    }

    @NotNull
    public static File getGDBBinFile(@NotNull String relativePath) {
        if (CidrDebuggerPathManager.isFromSources()) {
            String selector = SystemInfo.isWindows ? "win/" : (SystemInfo.isMac ? "mac/" : "linux/");
            return new File(new File(PathManager.getHomePath(), "CIDR/cidr-debugger/bin/GDB/" + selector), relativePath);
        }
        return new File(PathManager.getBinPath(), "gdb/bin/" + relativePath);
    }

    @NotNull
    public static File getBundledPythonHome() {
        if (CidrDebuggerPathManager.isFromSources()) {
            return new File(PathManager.getHomePath(), "CIDR/clion/bin/gdb");
        }
        return new File(PathManager.getBinPath(), "gdb");
    }

    @NotNull
    public static File getBundledGNUSTLPrettyPrinters() {
        if (CidrDebuggerPathManager.isFromSources()) {
            return new File(PathManager.getHomePath(), "CIDR/clion/bin/gdb/share/gdb/stl_printers");
        }
        return new File(PathManager.getBinPath(), "gdb/share/gdb/stl_printers");
    }

    private static boolean isFromSources() {
        return ApplicationImpl.isRunningFromSources();
    }
}

