/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportFactory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrErrorStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DBFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DBIllegalStateException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointHandler;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointHandler;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.ExpiredException;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebugProcess
extends XDebugProcess
implements DebuggerDriver.Handler,
UserDataHolderEx {
    public static final long ABORT_COMMAND_TIMEOUT = 3000L;
    public static final String BACKEND_CONTENT_ID = "DEBUGGER_BACKEND_CONSOLE";
    public static final Key<CidrDebugProcess> DEBUG_PROCESS_KEY = Key.create((String)CidrDebugProcess.class.getSimpleName());
    public static final Key THROW_ON_FRAME_COLLECTION = Key.create((String)"THROW_ON_FRAME_COLLECTION");
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    private final QueueProcessor<DebuggerCommand> myCommandQueue;
    private final MyProcessHandler myProcessHandler;
    private final DebuggerDriver myDriverDoNotUse;
    private final String myDriverName;
    private final ValueRendererFactory myRendererFactory;
    private final XDebuggerEditorsProvider myEditorsProvider;
    private final CidrBreakpointHandler myBreakpointHandler;
    private final CidrWatchpointHandler myWatchpointHandler;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final CidrExceptionBreakpointHandler myExceptionBreakpointHandler;
    @Nullable
    private final CidrSymbolicBreakpointHandler mySymbolicBreakpointHandler;
    private final Semaphore myAttachedSemaphore = new Semaphore(0);
    protected final ConsoleView myConsole;
    private volatile LanguageConsoleView myBackendConsole;
    private final boolean myWaitFor;
    protected final RunParameters myRunParameters;
    private final CidrDebuggerTypesHelper myTypesHelper = this.createTypesHelper();
    private final List<Couple<File>> mySymbolFiles = ContainerUtil.newArrayList();
    private volatile State myState = State.INITIALIZED;
    private volatile String myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
    private final Map<Pair<String, Integer>, CachedValue<List<String>>> myCompletionCache = new HashMap();

    public CidrDebugProcess(@NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder) throws ExecutionException {
        super(session);
        session.setPauseActionSupported(true);
        this.myCommandQueue = new QueueProcessor((Consumer)new MyCommandProcessor(), Conditions.alwaysFalse());
        this.myRunParameters = parameters;
        this.myWaitFor = parameters.isWaitFor();
        DebuggerDriverConfiguration configuration = parameters.getDebuggerDriverConfiguration();
        this.myRendererFactory = configuration.getValueRenderersFactory();
        this.myDriverName = configuration.getDriverName();
        this.myDriverDoNotUse = configuration.createDriver(this);
        this.myDriverDoNotUse.start(this.myRunParameters.getInstaller(), this.myRunParameters.getArchitectureId());
        this.myProcessHandler = new MyProcessHandler();
        final ProcessHandler driverProcessHandler = this.myDriverDoNotUse.getProcessHandler();
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                driverProcessHandler.startNotify();
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                CidrDebugProcess.this.doTerminateProcess(!willBeDestroyed);
            }
        });
        this.myEditorsProvider = CidrDebugProcess.createEditorsProvider(session.getRunProfile());
        this.myBreakpointHandler = this.createBreakpointHandler();
        this.myWatchpointHandler = new CidrWatchpointHandler(this);
        this.myExceptionBreakpointHandler = this.createExceptionHandler();
        this.mySymbolicBreakpointHandler = this.createSymbolicHandler();
        List handlersList = ContainerUtil.packNullables((Object[])new XBreakpointHandler[]{this.myBreakpointHandler, this.myWatchpointHandler, this.myExceptionBreakpointHandler, this.mySymbolicBreakpointHandler});
        this.myBreakpointHandlers = (XBreakpointHandler[])ContainerUtil.toArray((List)handlersList, (Object[])new XBreakpointHandler[handlersList.size()]);
        this.myConsole = consoleBuilder.getConsole();
    }

    @NotNull
    public String getCurrentStateMessage() {
        return this.myCurrentStateMessage;
    }

    @NotNull
    public ConsoleView getConsole() {
        return this.myConsole;
    }

    @NotNull
    private CidrDebuggerTypesHelper createTypesHelper() throws ExecutionException {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            CidrDebuggerTypesHelper typesHelper = factory.createTypesHelper(this);
            if (typesHelper == null) continue;
            return typesHelper;
        }
        throw new ExecutionException("Cannot create types helper for: " + this);
    }

    @NotNull
    private static XDebuggerEditorsProvider createEditorsProvider(RunProfile profile) throws ExecutionException {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            XDebuggerEditorsProvider editorsProvider = factory.createEditor(profile);
            if (editorsProvider == null) continue;
            return editorsProvider;
        }
        throw new ExecutionException("Cannot create editor for: " + profile.getClass());
    }

    public boolean isDetachDefault() {
        return false;
    }

    private void doTerminateProcess(boolean detachRequested) {
        this.myAttachedSemaphore.release();
        if (detachRequested) {
            if (this.isDetachDefault()) {
                detachRequested = true;
            } else {
                detachRequested = false;
                CidrDebuggerLog.LOG.error("Detaching the debug process is not supported");
            }
        }
        final boolean detach2 = detachRequested;
        final Alarm forceTerminateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        final Runnable terminateRunnable = new Runnable(){

            @Override
            public void run() {
                forceTerminateAlarm.cancelAllRequests();
                CidrDebugProcess.this.myDriverDoNotUse.getProcessHandler().destroyProcess();
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
                CidrDebugProcess.this.myState = detach2 ? State.DETACHED : State.FINISHED;
            }
        };
        forceTerminateAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                CidrDebuggerLog.LOG.warn("Cannot detach/abort. Forcing driver termination");
                terminateRunnable.run();
            }
        }, 3000L, ModalityState.any());
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    if (detach2) {
                        driver.detach();
                    } else {
                        driver.abort();
                    }
                }
                finally {
                    terminateRunnable.run();
                }
            }

            @Override
            public void rejected(@NotNull String reason) {
                terminateRunnable.run();
            }
        });
    }

    public boolean supportsWatchpoints() {
        return this.myDriverDoNotUse.supportsWatchpoints();
    }

    public boolean supportsWatchpointLifetime() {
        return this.myDriverDoNotUse.supportsWatchpointLifetime();
    }

    protected boolean isRemote() {
        return false;
    }

    public Project getProject() {
        return this.getSession().getProject();
    }

    @NotNull
    public ValueRendererFactory getRendererFactory() {
        return this.myRendererFactory;
    }

    public DebuggerDriver getDriverInTests() {
        return this.myDriverDoNotUse;
    }

    protected ProcessHandler doGetProcessHandler() {
        return this.myProcessHandler;
    }

    protected boolean waitForTermination() {
        return this.myDriverDoNotUse.getProcessHandler().waitFor();
    }

    boolean waitForAttach(int timeout) throws InterruptedException {
        return this.myAttachedSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public final void start() {
        this.myState = State.STARTING;
        this.myBackendConsole = new LanguageConsoleImpl(this.getProject(), this.myDriverName, this.myDriverDoNotUse.getConsoleLanguage());
        this.myBackendConsole.getConsoleEditor().getDocument().putUserData(DEBUG_PROCESS_KEY, this);
        this.myBackendConsole.setEditable(false);
        this.postCommand(new DebuggerStartupCommand(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                CidrDebugProcess.this.doStart(driver);
                List list = CidrDebugProcess.this.mySymbolFiles;
                synchronized (list) {
                    for (Couple file2 : CidrDebugProcess.this.mySymbolFiles) {
                        driver.addSymbolsFile((File)file2.first, (File)file2.second);
                    }
                    CidrDebugProcess.this.mySymbolFiles.clear();
                }
                CidrDebugProcess.this.myState = State.STARTED;
            }
        });
    }

    protected void doStart(@NotNull DebuggerDriver driver) throws ExecutionException {
        driver.loadForLaunch();
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(){

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                Content content = ui.createContent(CidrDebugProcess.BACKEND_CONTENT_ID, CidrDebugProcess.this.myBackendConsole.getComponent(), CidrDebugProcess.this.myDriverName, AllIcons.Debugger.ToolConsole, null);
                Disposer.register((Disposable)ui.getContentManager(), (Disposable)CidrDebugProcess.this.myBackendConsole);
                content.setCloseable(false);
                ui.addContent(content, 0, PlaceInGrid.center, false);
                for (BackendConsoleInjectionHelper helper : (BackendConsoleInjectionHelper[])BackendConsoleInjectionHelper.EP_NAME.getExtensions()) {
                    helper.subscribeToInjection(CidrDebugProcess.this.getSession());
                }
                LanguageConsoleBuilder.registerExecuteAction(CidrDebugProcess.this.myBackendConsole, new Consumer<String>(){

                    public void consume(String text) {
                        CidrDebugProcess.this.executeConsoleCommand(text);
                    }
                }, "AppCode.Debug.Console", null, null);
                CidrDebugProcess.this.getSession().addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

                    public void sessionPaused() {
                        this.enableConsole(true);
                    }

                    public void sessionResumed() {
                        this.enableConsole(false);
                    }

                    public void sessionStopped() {
                        this.enableConsole(false);
                    }

                    private void enableConsole(final boolean enabled) {
                        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                                    return;
                                }
                                CidrDebugProcess.this.myBackendConsole.setEditable(enabled);
                            }
                        });
                    }
                });
            }
        };
    }

    public boolean checkCanPerformCommands() {
        if (this.myDriverDoNotUse.isInPromptMode()) {
            this.getSession().reportMessage(CidrDebuggerBundle.message("debug.command.error.inPrompt", new Object[0]), MessageType.WARNING);
            RunnerLayoutUi ui = this.getSession().getUI();
            Content gdbContent = ui.findContent(BACKEND_CONTENT_ID);
            ui.selectAndFocus(gdbContent, true, true);
            return false;
        }
        return true;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.myEditorsProvider;
    }

    @NotNull
    protected CidrBreakpointHandler createBreakpointHandler() {
        return new CidrBreakpointHandler(this);
    }

    @NotNull
    protected CidrExceptionBreakpointHandler createExceptionHandler() {
        return new CidrExceptionBreakpointHandler(this, (Class<? extends CidrExceptionBreakpointType>)CidrExceptionBreakpointType.class);
    }

    @Nullable
    private CidrSymbolicBreakpointHandler createSymbolicHandler() {
        CidrSymbolicBreakpointType symbolicBreakpointType = (CidrSymbolicBreakpointType)((Object)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrSymbolicBreakpointType.class));
        return symbolicBreakpointType != null ? new CidrSymbolicBreakpointHandler(this, (Class<? extends XBreakpointType<XBreakpoint<CidrSymbolicBreakpointType.Properties>, ?>>)((Object)((Object)symbolicBreakpointType)).getClass()) : null;
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.myBreakpointHandlers;
    }

    @NotNull
    public ConsoleView createConsole() {
        this.myConsole.attachToProcess((ProcessHandler)this.myProcessHandler);
        return this.myConsole;
    }

    public LanguageConsoleView getDebuggerConsole() {
        return this.myBackendConsole;
    }

    public void sessionInitialized() {
        this.postCommand(new DebuggerStartupCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (CidrDebugProcess.this.myState != State.STARTED) {
                    return;
                }
                CidrDebugProcess.this.doLaunchTarget(driver);
                CidrDebugProcess.this.myCurrentStateMessage = XDebuggerBundle.message((String)"debugger.state.message.connected", (Object[])new Object[0]);
                CidrDebugProcess.this.getSession().rebuildViews();
            }
        });
    }

    protected void doLaunchTarget(@NotNull DebuggerDriver driver) throws ExecutionException {
        if (!this.myWaitFor || this.isRemote()) {
            driver.setRedirectOutputToFiles(!this.isRemote());
            driver.launch();
        } else {
            driver.attachByName(this.myRunParameters.getInstaller().getExecutableFile().getName(), true);
        }
    }

    public void stop() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CidrDebugProcess.this.getProject().isDisposed()) {
                    return;
                }
                CidrDebugProcess.this.myWatchpointHandler.cleanup();
            }
        });
        this.getProcessHandler().destroyProcess();
    }

    public void startPausing() {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.interrupt();
            }
        });
    }

    public void resume() {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.resume();
            }
        });
    }

    public void runToPosition(final @NotNull XSourcePosition position) {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.runTo(position.getFile().getPath(), position.getLine());
            }
        });
    }

    public void startStepOver() {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.stepOver();
            }
        });
    }

    public void startStepInto() {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.stepInto();
            }
        });
    }

    public void startStepOut() {
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.stepOut();
            }
        });
    }

    protected void executeConsoleCommand(final @NotNull String text) {
        final int threadId = this.getCurrentThreadId();
        final int number = this.getCurrentFrameNumber();
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.executeConsoleCommand(threadId, number, text);
            }
        });
    }

    public void postCommand(@NotNull DebuggerCommand command) {
        this.myCommandQueue.add((Object)command);
    }

    public void handleConsoleCompletion(CompletionParameters parameters, CompletionResultSet result) {
        int offset;
        final String command = parameters.getOriginalFile().getText();
        Pair key = new Pair((Object)command, (Object)(offset = parameters.getOffset() > 0 ? parameters.getOffset() - 1 : 0));
        CachedValueImpl<List<String>> cachedValue = this.myCompletionCache.get(key);
        if (cachedValue == null) {
            cachedValue = new CachedValueImpl<List<String>>((CachedValueProvider)new CachedValueProvider<List<String>>(){

                public CachedValueProvider.Result<List<String>> compute() {
                    final ArrayList completions = new ArrayList();
                    Semaphore completionSemaphore = new Semaphore(0);
                    CidrDebugProcess.this.postCommand(new DebuggerCommand(){

                        @Override
                        public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                            driver.handleCompletion(command, offset, completions);
                        }
                    });
                    try {
                        completionSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return new CachedValueProvider.Result(completions, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }){

                @Override
                public boolean isFromMyProject(Project project2) {
                    return true;
                }
            };
        }
        this.myCompletionCache.put((Pair<String, Integer>)key, cachedValue);
        List completions = (List)cachedValue.getValue();
        for (String str : completions) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)str));
        }
    }

    @Nullable
    public PsiElement getDebuggerContext() {
        return this.getDebuggerContext(this.getCurrentPosition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PsiElement getDebuggerContext(@Nullable XSourcePosition position) {
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            PsiElement psiElement = this.getTypesHelper().getContextElement(position);
            return psiElement;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        return this.myTypesHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSymbolsFile(File dSYM, File module2) {
        CidrDebuggerLog.LOG.assertTrue(this.myState == State.INITIALIZED, (Object)("Session is already started: " + (Object)((Object)this.myState)));
        List<Couple<File>> list = this.mySymbolFiles;
        synchronized (list) {
            this.mySymbolFiles.add((Couple<File>)Couple.of((Object)dSYM, (Object)module2));
        }
    }

    @NotNull
    public RunParameters getRunParameters() {
        return this.myRunParameters;
    }

    protected void handleCommandException(@NotNull DebuggerDriver driver, @NotNull DebuggerCommand command, @NotNull ExecutionException exception) {
        DBIllegalStateException illegalState = (DBIllegalStateException)((Object)ExceptionUtil.findCause((Throwable)exception, DBIllegalStateException.class));
        if (illegalState != null) {
            CidrDebuggerLog.LOG.info((Throwable)exception);
            String message = illegalState.getMessage();
            command.rejected(message);
            if (!(command instanceof DebuggerImplicitCommand)) {
                this.getSession().reportMessage(message, MessageType.WARNING);
            }
            return;
        }
        if (ExceptionUtil.causedBy((Throwable)exception, ExecutionFinishedException.class)) {
            if (!ExceptionUtil.causedBy((Throwable)exception, ProcessCanceledException.class)) {
                CidrDebuggerLog.LOG.debug((Throwable)exception);
            }
            this.getSession().stop();
            return;
        }
        boolean isFatalError = ExceptionUtil.causedBy((Throwable)exception, DBFatalException.class);
        if (command instanceof DebuggerStartupCommand || isFatalError) {
            CidrDebuggerLog.LOG.debug((Throwable)exception);
            this.printlnToConsole(exception.getMessage());
            this.reportErrorInRedBalloon(exception);
            if (isFatalError) {
                this.myDriverDoNotUse.getProcessHandler().destroyProcess();
            } else {
                this.getSession().stop();
            }
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            CidrDebuggerLog.LOG.warn((Throwable)exception);
        } else {
            CidrDebuggerLog.LOG.error((Throwable)exception);
        }
    }

    private void reportErrorInRedBalloon(ExecutionException e) {
        String message = e.getMessage();
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            CidrDebuggerLog.LOG.error("Execution errors must have error description", (Throwable)e);
        } else {
            this.getSession().reportMessage(message, MessageType.ERROR, e instanceof HyperlinkListener ? (HyperlinkListener)((Object)e) : null);
        }
    }

    public void printlnToConsole(@Nullable String message) {
        if (message != null && !this.getProject().isDisposed()) {
            if (!StringUtil.endsWithLineBreak((CharSequence)(message = StringUtil.stripHtml((String)message, (boolean)true)))) {
                message = message + "\n";
            }
            this.getProcessHandler().notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        }
    }

    @Nullable
    XSourcePosition getCurrentPosition() {
        XStackFrame frame = this.getSession().getCurrentStackFrame();
        return frame != null ? frame.getSourcePosition() : null;
    }

    public int getCurrentThreadId() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getThreadId() : -1;
    }

    public int getCurrentFrameNumber() {
        CidrStackFrame currentStackFrame = (CidrStackFrame)this.getSession().getCurrentStackFrame();
        return currentStackFrame != null ? currentStackFrame.getFrameNumber() : -1;
    }

    @Override
    public void handleRunning() {
        this.postCommand(new DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                CidrDebugProcess.this.getSession().sessionResumed();
            }
        });
    }

    @Override
    public void handleInterrupted(@NotNull List<LLThread> threads, int currentThreadIndex) {
        this.doHandleInterrupted(threads, currentThreadIndex, null);
    }

    @Override
    public void handleSignal(@NotNull List<LLThread> threads, int currentThreadIndex, @NotNull String signal, @NotNull String meaning) {
        this.doHandleInterrupted(threads, currentThreadIndex, new CidrSuspensionCause("Signal", signal + " (" + meaning + ")"));
    }

    @Override
    public void handleException(@NotNull List<LLThread> threads, int currentThreadIndex, @NotNull String description) {
        this.doHandleInterrupted(threads, currentThreadIndex, new CidrSuspensionCause("Exception", description + ")"));
    }

    @Override
    public void handleModulesLoaded(@NotNull List<String> modules) {
    }

    private void doHandleInterrupted(final List<LLThread> threads, final int currentThreadIndex, final @Nullable CidrSuspensionCause cause) {
        if (cause != null) {
            this.printlnToConsole(cause.getDisplayString());
        }
        this.postCommand(new DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                CidrDebugProcess.this.getSession().positionReached((XSuspendContext)new CidrSuspendContext(driver, threads, currentThreadIndex, cause));
            }
        });
    }

    @Override
    public void handleBreakpoint(int number, @NotNull List<LLThread> threads, int currentThreadIndex) {
        Object b = this.myBreakpointHandler.getCodepoint(number);
        if (b == null) {
            b = this.myExceptionBreakpointHandler.getCodepoint(number);
        }
        if (b == null && this.mySymbolicBreakpointHandler != null) {
            b = this.mySymbolicBreakpointHandler.getCodepoint(number);
        }
        this.handleXBreakpoint(threads, currentThreadIndex, (XBreakpoint<?>)b);
    }

    @Override
    public void handleWatchpoint(int num, List<LLThread> threads, int thread) {
        Object b = this.myWatchpointHandler.getCodepoint(num);
        this.handleXBreakpoint(threads, thread, (XBreakpoint<?>)b);
    }

    @Override
    public void handleAttached(int pid) {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.attachedTo", pid));
        this.myAttachedSemaphore.release();
    }

    @Override
    public void handleDetached() {
        this.printlnToConsole(CidrDebuggerBundle.message("debugger.detached", new Object[0]));
        this.getSession().stop();
    }

    protected void handleXBreakpoint(final List<LLThread> threads, final int currentThreadIndex, final @Nullable XBreakpoint<?> b) {
        this.postCommand(new DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                boolean shouldSuspend;
                XBreakpointProperties props;
                CidrSuspensionCause cause = null;
                XBreakpointProperties xBreakpointProperties = props = b != null ? b.getProperties() : null;
                if (props instanceof CidrExceptionBreakpointType.Properties) {
                    cause = new CidrSuspensionCause("Exception", "Exception breakpoint");
                }
                CidrSuspendContext suspendContext = new CidrSuspendContext(driver, threads, currentThreadIndex, cause);
                if (b == null) {
                    CidrDebugProcess.this.getSession().positionReached((XSuspendContext)suspendContext);
                    return;
                }
                String evaluated = null;
                String expression = b.getLogExpression();
                if (expression != null) {
                    XExecutionStack executionStack = suspendContext.getActiveExecutionStack();
                    XStackFrame frame = executionStack != null ? executionStack.getTopFrame() : null;
                    XSourcePosition sourcePosition = frame != null ? frame.getSourcePosition() : null;
                    CidrEvaluator evaluator = (CidrEvaluator)(frame != null ? frame.getEvaluator() : null);
                    if (evaluator != null) {
                        try {
                            CidrEvaluatedValue evaluatedValue = evaluator.doEvaluate(driver, sourcePosition, XExpressionImpl.fromText(expression));
                            evaluated = expression + " = " + evaluatedValue.getConsoleDescription(evaluatedValue.getContext(driver, null));
                        }
                        catch (DBUserException e) {
                            evaluated = "error evaluating " + expression + ": " + e.getMessage();
                        }
                    } else {
                        evaluated = "error evaluating " + expression;
                    }
                }
                if (!(shouldSuspend = CidrDebugProcess.this.getSession().breakpointReached(b, evaluated, (XSuspendContext)suspendContext))) {
                    CidrDebugProcess.this.resume();
                }
            }
        });
    }

    @Override
    public void handleTargetOutput(@NotNull String text, @NotNull Key type) {
        this.myProcessHandler.notifyTextAvailable(text, type);
    }

    @Override
    public void handleGDBOutput(final @NotNull String text) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CidrDebugProcess.this.myBackendConsole.print(text, ConsoleViewContentType.NORMAL_OUTPUT);
            }
        });
    }

    @Override
    public void handlePrompt(final @NotNull String prompt) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CidrDebugProcess.this.getProject().isDisposed() || Disposer.isDisposed((Disposable)CidrDebugProcess.this.myBackendConsole)) {
                    return;
                }
                CidrDebugProcess.this.getDebuggerConsole().setPrompt(prompt);
            }
        });
    }

    @Override
    public void handleTargetFinished(int code, @Nullable String description) {
        this.myProcessHandler.setExitCode(code);
        if (description != null) {
            this.myProcessHandler.notifyTextAvailable(description + "\n", ProcessOutputTypes.SYSTEM);
        }
        this.getSession().stop();
    }

    @Override
    public void handleTargetTerminated() {
        this.getSession().stop();
    }

    @Override
    public void handleExited(int code) {
        this.getSession().stop();
    }

    @Override
    public void handleWatchpointScope(final int wpnum) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CidrDebugProcess.this.myWatchpointHandler.handleWatchpointScope(wpnum);
            }
        });
        this.postCommand(new DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                driver.resume();
            }
        });
    }

    @NotNull
    protected XExecutionStack newExecutionStack(@NotNull DebuggerDriver driver, @NotNull LLThread thread, boolean current, @Nullable CidrSuspensionCause suspensionCause) throws ExecutionException {
        return new CidrExecutionStack(driver, thread, current, suspensionCause);
    }

    private class CidrExecutionStack
    extends XExecutionStack {
        @NotNull
        private final LLThread myThread;
        private final List<XStackFrame> myFrames;
        @Nullable
        private final CidrSuspensionCause mySuspensionCause;

        public CidrExecutionStack(@NotNull DebuggerDriver driver, LLThread thread, @Nullable boolean current, CidrSuspensionCause suspensionCause) throws ExecutionException {
            super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
            this.myThread = thread;
            this.mySuspensionCause = suspensionCause;
            this.myFrames = new ArrayList<XStackFrame>();
            try {
                ThrowInTest.doThrow((UserDataHolder)CidrDebugProcess.this, THROW_ON_FRAME_COLLECTION);
                List<LLFrame> frames = driver.getFrames(this.myThread.getId());
                CidrStackFrame prev = null;
                for (LLFrame each : ContainerUtil.reverse(frames)) {
                    CidrStackFrame frame = new CidrStackFrame(CidrDebugProcess.this, this.myThread.getId(), each, prev, suspensionCause);
                    this.myFrames.add(frame);
                    prev = frame;
                }
                Collections.reverse(this.myFrames);
            }
            catch (DBUserException e) {
                this.myFrames.add(new CidrErrorStackFrame(e.getMessage()));
            }
        }

        public XStackFrame getTopFrame() {
            return this.myFrames.isEmpty() ? null : this.myFrames.get(0);
        }

        public void computeStackFrames(int from, XExecutionStack.XStackFrameContainer container) {
            List doAdd = from >= this.myFrames.size() ? Collections.emptyList() : this.myFrames.subList(from, this.myFrames.size());
            container.addStackFrames(doAdd, true);
        }

        @Nullable
        public GutterIconRenderer getExecutionLineIconRenderer() {
            if (this.mySuspensionCause == null) {
                return super.getExecutionLineIconRenderer();
            }
            return new GutterIconRenderer(){

                @NotNull
                public Icon getIcon() {
                    return ((CidrExecutionStack)CidrExecutionStack.this).mySuspensionCause.icon;
                }

                @Nullable
                public String getTooltipText() {
                    return CidrExecutionStack.this.mySuspensionCause.getDisplayString();
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                        return false;
                    }
                    return Comparing.equal((Object)CidrExecutionStack.this.mySuspensionCause, (Object)((CidrExecutionStack)((Object)o)).mySuspensionCause);
                }

                public int hashCode() {
                    return CidrExecutionStack.this.mySuspensionCause.hashCode();
                }

                public boolean isDumbAware() {
                    return true;
                }
            };
        }

        public String toString() {
            return this.myThread.toString();
        }
    }

    private class CidrSuspendContext
    extends XSuspendContext {
        private final XExecutionStack[] myStacks;
        @Nullable
        private final XExecutionStack myActiveStack;
        @Nullable
        private final CidrSuspensionCause mySuspensionCause;

        public CidrSuspendContext(DebuggerDriver driver, List<LLThread> threads, @Nullable int currentThreadIndex, CidrSuspensionCause cause) throws ExecutionException {
            this.mySuspensionCause = cause;
            this.myStacks = new XExecutionStack[threads.size()];
            XExecutionStack activeStack = null;
            for (int i = 0; i < threads.size(); ++i) {
                XExecutionStack stack;
                boolean isCurrent = i == currentThreadIndex;
                this.myStacks[i] = stack = CidrDebugProcess.this.newExecutionStack(driver, threads.get(i), isCurrent, isCurrent ? this.mySuspensionCause : null);
                if (!isCurrent) continue;
                activeStack = stack;
            }
            this.myActiveStack = activeStack;
            CidrDebuggerLog.LOG.assertTrue(this.myActiveStack != null, (Object)("active thread " + currentThreadIndex + " not found in threads: " + threads));
        }

        @Nullable
        public XExecutionStack getActiveExecutionStack() {
            return this.myActiveStack;
        }

        public XExecutionStack[] getExecutionStacks() {
            return this.myStacks;
        }
    }

    private class MyCommandProcessor
    implements Consumer<DebuggerCommand> {
        private MyCommandProcessor() {
        }

        public void consume(DebuggerCommand c) {
            ProcessHandler driverHandler = CidrDebugProcess.this.myDriverDoNotUse.getProcessHandler();
            if (driverHandler.isProcessTerminating() || driverHandler.isProcessTerminated()) {
                c.rejected("Process finished");
                return;
            }
            try {
                c.run(CidrDebugProcess.this.myDriverDoNotUse);
            }
            catch (ExpiredException expiredException) {
            }
            catch (ExecutionException e) {
                CidrDebugProcess.this.handleCommandException(CidrDebugProcess.this.myDriverDoNotUse, c, e);
            }
        }
    }

    private class MyProcessHandler
    extends ProcessHandler
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private final AtomicReference<Integer> myExitCode = new AtomicReference();
        private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();

        private MyProcessHandler() {
        }

        public void setExitCode(int exitCode) {
            this.myExitCode.set(exitCode);
        }

        public int getExitCode() {
            Integer exitCode = this.myExitCode.get();
            return exitCode == null ? 0 : exitCode;
        }

        protected void destroyProcessImpl() {
            this.doDestroyOrDetach(false);
        }

        protected void detachProcessImpl() {
            this.doDestroyOrDetach(true);
        }

        private void doDestroyOrDetach(final boolean detach2) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    if (CidrDebugProcess.this.waitForTermination()) {
                        if (detach2) {
                            MyProcessHandler.this.notifyProcessDetached();
                        } else {
                            MyProcessHandler.this.notifyProcessTerminated(MyProcessHandler.this.getExitCode());
                        }
                    }
                }
            });
        }

        public boolean detachIsDefault() {
            return CidrDebugProcess.this.isDetachDefault();
        }

        public OutputStream getProcessInput() {
            return CidrDebugProcess.this.myDriverDoNotUse.getProcessInput();
        }

        public final void notifyTextAvailable(String text, Key outputType) {
            this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
        }

        public void coloredTextAvailable(String text, Key attributes) {
            super.notifyTextAvailable(text, attributes);
        }
    }

    public static abstract class DebuggerImplicitCommand
    extends DebuggerCommand {
    }

    public static abstract class DebuggerStartupCommand
    extends DebuggerCommand {
    }

    public static abstract class DebuggerCommand {
        public abstract void run(@NotNull DebuggerDriver var1) throws ExecutionException;

        public void rejected(@NotNull String reason) {
        }
    }

    static enum State {
        INITIALIZED,
        STARTING,
        STARTED,
        FINISHED,
        DETACHED;

    }
}

