/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.OutputReader;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileOutputReaders {
    private Charset myEncoding;
    private final List<MyOutputReader> myReaders = new LinkedList<MyOutputReader>();
    private File myOutFile;
    private File myErrFile;
    private Pty myOutPty;
    private Pty myErrPty;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(@NotNull GeneralCommandLine commandLine, boolean usePty) throws ExecutionException {
        block9: {
            this.myEncoding = commandLine.getCharset();
            try {
                if (usePty) {
                    this.myOutPty = new Pty(true);
                    this.myErrPty = new Pty(true);
                    List<MyOutputReader> list = this.myReaders;
                    synchronized (list) {
                        this.myReaders.add(new MyOutputReader(this.myOutPty, commandLine, ProcessOutputTypes.STDOUT));
                        this.myReaders.add(new MyOutputReader(this.myErrPty, commandLine, ProcessOutputTypes.STDERR));
                        break block9;
                    }
                }
                this.myOutFile = FileUtil.createTempFile((String)this.getClass().getSimpleName(), (String)"out");
                this.myErrFile = FileUtil.createTempFile((String)this.getClass().getSimpleName(), (String)"err");
                List<MyOutputReader> list = this.myReaders;
                synchronized (list) {
                    this.myReaders.add(new MyOutputReader(this.myOutFile, commandLine, ProcessOutputTypes.STDOUT));
                    this.myReaders.add(new MyOutputReader(this.myErrFile, commandLine, ProcessOutputTypes.STDERR));
                }
            }
            catch (IOException e) {
                throw new ExecutionException("Cannot create output file", (Throwable)e);
            }
        }
    }

    public String getOutFileAbsolutePath() {
        return this.myOutPty != null ? this.myOutPty.getSlaveName() : this.myOutFile.getAbsolutePath();
    }

    public String getErrFileAbsolutePath() {
        return this.myErrPty != null ? this.myErrPty.getSlaveName() : this.myErrFile.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<MyOutputReader> list = this.myReaders;
        synchronized (list) {
            for (MyOutputReader each : this.myReaders) {
                each.stop();
            }
            for (MyOutputReader each : this.myReaders) {
                try {
                    each.waitFor();
                }
                catch (InterruptedException ignore) {
                    break;
                }
            }
            for (MyOutputReader each : this.myReaders) {
                File file2 = each.getFile();
                if (file2 == null) continue;
                FileUtil.delete((File)file2);
            }
            this.myReaders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully() {
        List<MyOutputReader> list = this.myReaders;
        synchronized (list) {
            for (MyOutputReader each : this.myReaders) {
                try {
                    each.readFully();
                }
                catch (InterruptedException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                }
            }
        }
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key var2);

    private class MyOutputReader
    extends OutputReader {
        private final File myFile;
        private final Key myType;

        private MyOutputReader(@NotNull File file2, @NotNull GeneralCommandLine commandLine, Key type) throws IOException {
            super((InputStream)new FileInputStream(file2), FileOutputReaders.this.myEncoding, "");
            this.myFile = file2;
            this.myType = type;
            super.start(CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()));
        }

        private MyOutputReader(@NotNull Pty pty, @NotNull GeneralCommandLine commandLine, Key type) {
            super((InputStream)pty.getInputStream(), FileOutputReaders.this.myEncoding, BaseDataReader.SleepingPolicy.BLOCKING, CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()));
            this.myFile = null;
            this.myType = type;
            super.start(CommandLineUtil.extractPresentableName((String)commandLine.getCommandLineString()));
        }

        protected void start(@NotNull String presentableName) {
        }

        @Nullable
        public File getFile() {
            return this.myFile;
        }

        protected void onTextAvailable(@NotNull String text) {
            FileOutputReaders.this.onTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
            return ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }
    }
}

