/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrRunConfigurationSettingsEditor<CONFIGURATION extends CidrRunConfiguration, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends SettingsEditor<CONFIGURATION>
implements PanelWithAnchor {
    protected final Project myProject;
    protected final BCH myConfigHelper;
    private JComponent myAnchor;
    private JBLabel myTargetLabel;
    protected ComboBox myTargetCombo;
    protected ComboBox myConfigurationCombo;
    private CommonProgramParametersPanel myCommonProgramParameters;

    public CidrRunConfigurationSettingsEditor(Project project2, @NotNull BCH configHelper) {
        this.myProject = project2;
        this.myConfigHelper = configHelper;
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultFill(1).setDefaultAnchor(10).setDefaultWeightX(1, 1.0).setDefaultInsets(0, new Insets(0, 0, 4, 10)).setDefaultInsets(1, new Insets(0, 0, 4, 0));
        this.createEditorInner(panel, g);
        this.setAnchor(this.myCommonProgramParameters.getAnchor());
        return panel;
    }

    protected void createEditorInner(JPanel panel, GridBag g) {
        this.myTargetLabel = new JBLabel(CidrBundle.message("build.configuration.target", new Object[0]) + ":");
        panel.add((Component)this.myTargetLabel, g.nextLine().next());
        this.myTargetCombo = CidrRunConfigurationSettingsEditor.createCombo();
        panel.add((Component)this.myTargetCombo, g.next().coverLine());
        this.myTargetLabel.setLabelFor((Component)this.myTargetCombo);
        JLabel label = new JLabel(CidrBundle.message("build.configuration.configuration", new Object[0]) + ":");
        panel.add((Component)label, g.nextLine().next());
        this.myConfigurationCombo = CidrRunConfigurationSettingsEditor.createCombo();
        panel.add((Component)this.myConfigurationCombo, g.next().coverLine());
        label.setLabelFor((Component)this.myConfigurationCombo);
        this.createAdditionalControls(panel, g);
        this.myCommonProgramParameters = new CommonProgramParametersPanel();
        panel.add((Component)this.myCommonProgramParameters, g.nextLine().weighty(1.0).insets(8, -1, 8, -1).coverLine());
        this.myTargetCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2 && CidrRunConfigurationSettingsEditor.this.myTargetCombo.getItemCount() > 0) {
                    return;
                }
                final CidrBuildTargetWithConfigurations target = e.getStateChange() == 1 ? (CidrBuildTargetWithConfigurations)CidrRunConfigurationSettingsEditor.getItem(e) : null;
                new ReadAction(){

                    protected void run(@NotNull Result result) throws Throwable {
                        CidrRunConfigurationSettingsEditor.this.myConfigurationCombo.setModel(new DefaultComboBoxModel<Object>(((CidrBuildConfigurationHelper)CidrRunConfigurationSettingsEditor.this.myConfigHelper).getConfigurations((CidrBuildTargetWithConfigurations)target).toArray()));
                        CidrRunConfigurationSettingsEditor.this.myConfigurationCombo.setSelectedItem(null);
                        CidrRunConfigurationSettingsEditor.this.myConfigurationCombo.setSelectedItem((Object)((CidrBuildConfigurationHelper)CidrRunConfigurationSettingsEditor.this.myConfigHelper).getDefaultConfiguration((CidrBuildTargetWithConfigurations)target));
                    }
                }.execute();
                CidrRunConfigurationSettingsEditor.this.onTargetSelected(target);
            }
        });
        this.myTargetCombo.setModel(new DefaultComboBoxModel<Object>(this.getTargets().toArray()));
        this.myTargetCombo.setSelectedItem(null);
        this.myTargetCombo.setRenderer((ListCellRenderer)this.getTargetsRenderer());
        this.myConfigurationCombo.setRenderer((ListCellRenderer)this.getTargetsRenderer());
    }

    @NotNull
    protected List<TARGET> getTargets() {
        return ((CidrBuildConfigurationHelper)this.myConfigHelper).getTargets();
    }

    protected boolean hasTargetsInSeveralProjects() {
        return false;
    }

    @NotNull
    protected MyBaseRenderer getTargetsRenderer() {
        return new MyBaseRenderer(this.hasTargetsInSeveralProjects());
    }

    protected void createAdditionalControls(JPanel panel, GridBag g) {
    }

    @NotNull
    protected static MyComboBox createCombo() {
        return new MyComboBox(10);
    }

    protected void onTargetSelected(@Nullable TARGET target) {
    }

    protected void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        this.resetBuildAndConfigurationFrom(runConfiguration);
        this.myCommonProgramParameters.reset((CommonProgramRunConfigurationParameters)runConfiguration);
    }

    protected void resetBuildAndConfigurationFrom(@NotNull CONFIGURATION runConfiguration) {
        final BuildTargetAndConfigurationData buildData = ((CidrRunConfiguration)runConfiguration).getTargetAndConfigurationData();
        final BuildTargetData buildTargetData = buildData == null ? null : buildData.target;
        new ReadAction(){

            protected void run(@NotNull Result result) throws Throwable {
                Object buildTarget = ((CidrBuildConfigurationHelper)CidrRunConfigurationSettingsEditor.this.myConfigHelper).findTarget(buildTargetData);
                Object buildConfig = ((CidrBuildConfigurationHelper)CidrRunConfigurationSettingsEditor.this.myConfigHelper).findConfiguration(buildTarget, buildData == null ? null : buildData.configurationName);
                CidrRunConfigurationSettingsEditor.setSelectedItem(CidrRunConfigurationSettingsEditor.this.myTargetCombo, buildTarget, buildTargetData);
                CidrRunConfigurationSettingsEditor.setSelectedItem(CidrRunConfigurationSettingsEditor.this.myConfigurationCombo, buildConfig, buildData == null ? null : buildData.configurationName);
            }
        }.execute();
    }

    protected void applyEditorTo(CONFIGURATION runConfiguration) throws ConfigurationException {
        this.applyBuildAndConfigurationTo(runConfiguration);
        this.myCommonProgramParameters.applyTo((CommonProgramRunConfigurationParameters)runConfiguration);
    }

    protected void applyBuildAndConfigurationTo(@NotNull CONFIGURATION runConfiguration) {
        CidrBuildTargetWithConfigurations selectedBuildTarget = (CidrBuildTargetWithConfigurations)CidrRunConfigurationSettingsEditor.getSelectedItem((JComboBox)this.myTargetCombo);
        CidrBuildConfiguration selectedConfiguration = (CidrBuildConfiguration)CidrRunConfigurationSettingsEditor.getSelectedItem((JComboBox)this.myConfigurationCombo);
        BuildTargetData selectedBuildTargetData = selectedBuildTarget != null ? new BuildTargetData(selectedBuildTarget) : (BuildTargetData)CidrRunConfigurationSettingsEditor.getSelectedInvalidItemValue((JComboBox)this.myTargetCombo);
        String selectedConfigurationName = selectedConfiguration != null ? selectedConfiguration.getName() : (String)CidrRunConfigurationSettingsEditor.getSelectedInvalidItemValue((JComboBox)this.myConfigurationCombo);
        ((CidrRunConfiguration)runConfiguration).setTargetAndConfigurationData(new BuildTargetAndConfigurationData(selectedBuildTargetData, selectedConfigurationName));
        this.syncBuildAndExecute(runConfiguration, selectedBuildTargetData);
    }

    protected void syncBuildAndExecute(@NotNull CONFIGURATION configuration, @Nullable BuildTargetData buildTargetData) {
    }

    protected static void setSelectedItem(@NotNull ComboBox combo, @Nullable Object item, @Nullable Object invalidItemValue) {
        item = CidrRunConfigurationSettingsEditor.createComboBoxItem(item, invalidItemValue);
        boolean exists = false;
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!Comparing.equal((Object)item, (Object)combo.getItemAt(i))) continue;
            exists = true;
            break;
        }
        if (!exists) {
            combo.addItem(item);
        }
        combo.setSelectedItem(item);
    }

    public static Object createComboBoxItem(Object item, Object invalidItemValue) {
        if (item == null && invalidItemValue != null) {
            item = new InvalidItem(invalidItemValue);
        }
        return item;
    }

    @Nullable
    protected static Object getItem(ItemEvent e) {
        Object result = e.getItem();
        return result instanceof InvalidItem ? null : result;
    }

    @Nullable
    protected static Object getSelectedItem(JComboBox combo) {
        Object result = combo.getSelectedItem();
        return result instanceof InvalidItem ? null : result;
    }

    @Nullable
    protected static Object getSelectedInvalidItemValue(JComboBox combo) {
        Object result = combo.getSelectedItem();
        return result instanceof InvalidItem ? ((InvalidItem)result).myValue : null;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myCommonProgramParameters.setAnchor(anchor);
        this.myTargetLabel.setAnchor(anchor);
    }

    protected static class MyBaseRenderer
    extends GroupedElementsRenderer.List
    implements ListCellRenderer {
        private final boolean hasTargetsInSeveralProjects;
        private SimpleColoredComponent myComponent;

        public MyBaseRenderer(boolean hasTargetsInSeveralProjects) {
            this.hasTargetsInSeveralProjects = hasTargetsInSeveralProjects;
        }

        protected JComponent createItemComponent() {
            this.myTextLabel = new ErrorLabel();
            this.myComponent = new SimpleColoredComponent(){
                {
                    this.setFocusBorderAroundIcon(true);
                }
            };
            return this.myComponent;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.myComponent.clear();
            this.customizeCellRenderer(this.myComponent, list, value, index, isSelected, cellHasFocus);
            String separator = index == -1 ? null : this.getSeparatorAbove(list, value, index);
            this.configureComponent(null, null, null, null, isSelected, separator != null, StringUtil.isEmptyOrSpaces((String)separator) ? null : separator, -1);
            this.myComponent.setOpaque(isSelected);
            this.myRendererComponent.setBackground(this.myComponent.getBackground());
            return this.myRendererComponent;
        }

        protected String getSeparatorAbove(JList list, Object value, int index) {
            return index > 0 && list.getModel().getElementAt(index - 1) == null ? "" : null;
        }

        protected void customizeCellRenderer(SimpleColoredComponent component, JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof InvalidItem) {
                this.appendNotFound(((InvalidItem)value).myValue, selected);
            } else {
                if (value instanceof CidrBuildTarget) {
                    CidrBuildTarget target = (CidrBuildTarget)value;
                    component.setIcon(target.getIcon());
                    component.append(target.getName());
                    if (this.hasTargetsInSeveralProjects) {
                        component.append(" (" + target.getProjectName() + ")", this.grayed(selected));
                    }
                    return;
                }
                if (value instanceof CidrBuildConfiguration) {
                    value = ((CidrBuildConfiguration)value).getName();
                }
                this.addValue(component, list, value, selected);
            }
        }

        protected void appendNotFound(Object value, boolean isSelected) {
            this.myComponent.append(String.valueOf(value), isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
            this.myComponent.append(" (" + CidrBundle.message("build.configuration.dialog.item.parameterNotFound", new Object[0]) + ")", this.grayed(isSelected));
        }

        protected SimpleTextAttributes grayed(boolean isSelected) {
            return isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        }

        protected void addValue(SimpleColoredComponent component, JList list, Object value, boolean selected) {
            SimpleTextAttributes attribs = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (value == null) {
                value = list.getModel().getSize() == 0 ? CidrBundle.message("build.configuration.dialog.item.parameterNoVariants", new Object[0]) : CidrBundle.message("build.configuration.dialog.item.parameterNotSelected", new Object[0]);
                attribs = this.grayed(selected);
            }
            component.append(String.valueOf(value), attribs);
        }
    }

    protected static class MyComboBox
    extends ComboBox {
        public MyComboBox(int width) {
            super(width);
        }

        public void fireSelectedItemChanged() {
            this.selectedItemChanged();
        }
    }

    protected static class InvalidItem {
        @NotNull
        Object myValue;

        private InvalidItem(@NotNull Object value) {
            this.myValue = value;
        }

        public String toString() {
            return this.myValue.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidItem item = (InvalidItem)o;
            return this.myValue.equals(item.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }
    }
}

