/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.ide.NativeIconProvider;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationSettingsEditor;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.OCLog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRunConfigurationExecutableEditor<RC extends CidrRunConfiguration, BC extends CidrBuildConfiguration, T extends CidrBuildTargetWithConfigurations<BC>, BCH extends CidrBuildConfigurationHelper<BC, T>> {
    private final String SELECT_EXTERNAL_EXECUTABLE = CidrBundle.message("build.configuration.dialog.item.selectOther", new Object[0]);
    private final Project myProject;
    private final BCH myConfigHelper;
    private final ComboBox myExecutableCombo;

    public CidrRunConfigurationExecutableEditor(Project project2, @NotNull BCH configHelper, boolean hasTargetsInSeveralProjects) {
        this.myProject = project2;
        this.myConfigHelper = configHelper;
        this.myExecutableCombo = CidrRunConfigurationSettingsEditor.createCombo();
        this.myExecutableCombo.setRenderer((ListCellRenderer)new MyExecutablesRenderer(hasTargetsInSeveralProjects));
        this.updateExecutablesModel(false, null, null);
        this.myExecutableCombo.addActionListener(new ActionListener(){
            Object lastSelection;
            {
                this.lastSelection = CidrRunConfigurationExecutableEditor.this.myExecutableCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = CidrRunConfigurationExecutableEditor.this.myExecutableCombo.getSelectedItem();
                if (selection != CidrRunConfigurationExecutableEditor.this.SELECT_EXTERNAL_EXECUTABLE) {
                    this.lastSelection = selection;
                    return;
                }
                selection = this.lastSelection;
                CidrRunConfigurationExecutableEditor.this.myExecutableCombo.setSelectedItem(this.lastSelection);
                FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(@NotNull VirtualFile file2) {
                        return this.isSelectable(file2);
                    }
                };
                VirtualFile toSelect = null;
                if (selection instanceof File) {
                    toSelect = LocalFileSystem.getInstance().findFileByIoFile((File)selection);
                }
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)CidrRunConfigurationExecutableEditor.this.myProject, (VirtualFile)toSelect, (Consumer)new Consumer<List<VirtualFile>>(){

                    public void consume(List<VirtualFile> files) {
                        VirtualFile selectedVirtualFile = (VirtualFile)ContainerUtil.getFirstItem(files);
                        File file2 = selectedVirtualFile == null || !this.isSelectable(selectedVirtualFile) ? null : new File(selectedVirtualFile.getPath());
                        CidrRunConfigurationExecutableEditor.this.updateExecutablesModel(true, file2, null);
                    }
                });
            }

            private boolean isSelectable(@NotNull VirtualFile file2) {
                if (file2.isDirectory()) {
                    return "app".equals(file2.getExtension());
                }
                return new File(file2.getPath()).canExecute();
            }
        });
    }

    private void updateExecutablesModel(boolean preserveCurrentItems, Object selectedItem, ExecutableData invalidItemData) {
        Object toSelect = CidrRunConfigurationSettingsEditor.createComboBoxItem(selectedItem, invalidItemData);
        ArrayList<Object> allExecutables = new ArrayList<Object>();
        if (toSelect != null && !allExecutables.contains(toSelect)) {
            allExecutables.add(toSelect);
        }
        allExecutables.add(null);
        allExecutables.addAll(((CidrBuildConfigurationHelper)this.myConfigHelper).getRunTargets());
        allExecutables.add(this.SELECT_EXTERNAL_EXECUTABLE);
        if (preserveCurrentItems) {
            ComboBoxModel m = this.myExecutableCombo.getModel();
            for (int i = 0; i < m.getSize(); ++i) {
                allExecutables.add(m.getElementAt(i));
            }
        }
        ContainerUtil.removeDuplicates(allExecutables);
        Collections.sort(allExecutables, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return this.getWeight(o1) - this.getWeight(o2);
            }

            private int getWeight(Object o) {
                if (o == null) {
                    return 0;
                }
                if (o == CidrRunConfigurationExecutableEditor.this.SELECT_EXTERNAL_EXECUTABLE) {
                    return 10;
                }
                Class<?> c = o.getClass();
                if (CidrBuildTarget.class.isAssignableFrom(c)) {
                    return 1;
                }
                if (CidrRunConfigurationSettingsEditor.InvalidItem.class.isAssignableFrom(c)) {
                    return 2;
                }
                if (File.class.isAssignableFrom(c)) {
                    return 3;
                }
                return 4;
            }
        });
        this.myExecutableCombo.setModel(new DefaultComboBoxModel<Object>(allExecutables.toArray()));
        this.myExecutableCombo.setSelectedItem(toSelect);
    }

    public void createAdditionalControls(JPanel panel, GridBag g) {
        JLabel label = new JLabel(CidrBundle.message("build.configuration.executable", new Object[0]) + ":");
        panel.add((Component)label, g.nextLine().next());
        panel.add((Component)this.myExecutableCombo, g.next().coverLine());
        label.setLabelFor((Component)this.myExecutableCombo);
    }

    public void onTargetSelected(@Nullable T target) {
        if (target != null && target.isExecutable()) {
            this.myExecutableCombo.setSelectedItem(null);
            this.myExecutableCombo.setSelectedItem(target);
        }
    }

    public void resetEditorFrom(@NotNull RC runConfiguration) {
        ExecutableData executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        Object executable = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        if (executableData != null) {
            if (executableData.target != null) {
                executable = ((CidrBuildConfigurationHelper)this.myConfigHelper).findRunTarget(executableData.target);
            } else if (executableData.path != null) {
                executable = new File(executableData.path);
            }
        }
        this.updateExecutablesModel(false, executable, executableData);
    }

    public void applyEditorTo(RC runConfiguration) throws ConfigurationException {
        ExecutableData executableData;
        Object selectedExecutable = CidrRunConfigurationSettingsEditor.getSelectedItem((JComboBox)this.myExecutableCombo);
        if (selectedExecutable == null) {
            executableData = (ExecutableData)CidrRunConfigurationSettingsEditor.getSelectedInvalidItemValue((JComboBox)this.myExecutableCombo);
        } else if (selectedExecutable instanceof CidrBuildTarget) {
            executableData = new ExecutableData(new BuildTargetData((CidrBuildTarget)selectedExecutable));
        } else if (selectedExecutable instanceof File) {
            executableData = new ExecutableData(((File)selectedExecutable).getPath());
        } else {
            OCLog.LOG.assertTrue(this.SELECT_EXTERNAL_EXECUTABLE.equals(selectedExecutable), (Object)("Unexpected selection: " + selectedExecutable));
            executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        }
        ((CidrExecutableDataHolder)runConfiguration).setExecutableData(executableData);
    }

    private class MyExecutablesRenderer
    extends CidrRunConfigurationSettingsEditor.MyBaseRenderer {
        public MyExecutablesRenderer(boolean hasTargetsInSeveralProjects) {
            super(hasTargetsInSeveralProjects);
        }

        @Override
        protected void appendNotFound(Object value, boolean selected) {
            if (value instanceof ExecutableData) {
                String path = ((ExecutableData)value).path;
                value = path != null ? new File(path).getName() : ((ExecutableData)value).target;
            }
            super.appendNotFound(value, selected);
        }

        @Override
        protected String getSeparatorAbove(JList list, Object value, int index) {
            if (index == 0) {
                return null;
            }
            if (value == CidrRunConfigurationExecutableEditor.this.SELECT_EXTERNAL_EXECUTABLE) {
                return "";
            }
            Object previous = list.getModel().getElementAt(index - 1);
            if (value instanceof File && !(previous instanceof File)) {
                return "";
            }
            return super.getSeparatorAbove(list, value, index);
        }

        @Override
        protected void customizeCellRenderer(SimpleColoredComponent component, JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof File) {
                File file2 = (File)value;
                component.setIcon(NativeIconProvider.getNativeIcon(file2));
                if (!file2.exists()) {
                    this.appendNotFound(file2.getName(), selected);
                } else {
                    component.append(file2.getName());
                }
                return;
            }
            super.customizeCellRenderer(component, list, value, index, selected, hasFocus);
        }
    }
}

