/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.jetbrains.cidr.execution.CidrExecUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCommandLineConfigurator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SimpleProgramParameters myAppParameters;

    public CidrCommandLineConfigurator(@NotNull Project project2, @NotNull SimpleProgramParameters appParameters) {
        this.myProject = project2;
        this.myAppParameters = appParameters;
    }

    @Nullable
    public File getAppWorkingDir() {
        String result = this.myAppParameters.getWorkingDirectory();
        return StringUtil.isEmptyOrSpaces((String)result) ? null : new File(result);
    }

    public void configureCommandLine(@NotNull GeneralCommandLine cl) throws ExecutionException {
        Charset charset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        cl.setCharset(charset);
        cl.setWorkDirectory(this.getAppWorkingDir());
        cl.getParametersList().addAll(this.myAppParameters.getProgramParametersList().getList());
        Map env = cl.getEnvironment();
        env.putAll(this.myAppParameters.getEnv());
        if (SystemInfo.isMac) {
            CidrExecUtil.setIfAbsent(env, "NSUnbufferedIO", "YES");
        }
        cl.withParentEnvironmentType(this.myAppParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }
}

