/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectOpenHelper {
    private final Key<VirtualFile> myOpenFileKey;
    private final FileType[] mySupportedTypes;

    public ProjectOpenHelper(@NotNull Key<VirtualFile> openFileKey, FileType ... supportedTypes) {
        this.myOpenFileKey = openFileKey;
        this.mySupportedTypes = supportedTypes;
    }

    public boolean canOpenProject(@Nullable VirtualFile file2) {
        return file2 != null && this.isSupportedFile(file2.getFileType());
    }

    public boolean canOpenProject(@Nullable String fileName) {
        return fileName != null && this.isSupportedFile(FileTypeRegistry.getInstance().getFileTypeByFileName(fileName));
    }

    private boolean isSupportedFile(@Nullable FileType type) {
        return Arrays.asList(this.mySupportedTypes).contains(type);
    }

    @Nullable
    public Project openProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        if (!this.canOpenProject(virtualFile)) {
            return null;
        }
        virtualFile.refresh(false, true);
        VirtualFile baseDir = virtualFile.getParent();
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (!Comparing.equal((Object)baseDir, (Object)project2.getBaseDir())) continue;
            ProjectUtil.focusProjectWindow(project2, false);
            return project2;
        }
        this.markFileToOpen(virtualFile);
        return PlatformProjectOpenProcessor.getInstance().doOpenProject(baseDir, projectToClose, forceOpenInNewFrame);
    }

    public void markFileToOpen(@NotNull VirtualFile virtualFile) {
        VirtualFile baseDir = virtualFile.getParent();
        baseDir.putUserData(this.myOpenFileKey, (Object)virtualFile);
    }

    @Nullable
    public VirtualFile getAndClearFileToOpen(@NotNull Project project2) {
        VirtualFile baseDir = project2.getBaseDir();
        if (baseDir == null) {
            return null;
        }
        VirtualFile fileToOpen = (VirtualFile)baseDir.getUserData(this.myOpenFileKey);
        baseDir.putUserData(this.myOpenFileKey, null);
        return fileToOpen;
    }
}

