/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.jetbrains.cidr.ProjectOpenHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    private final String myName;
    @NotNull
    private final ProjectOpenHelper myHelper;

    protected CidrProjectOpenProcessor(@NotNull String name, @NotNull ProjectOpenHelper helper) {
        this.myName = name;
        this.myHelper = helper;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return null;
    }

    public boolean canOpenProject(VirtualFile file2) {
        return this.myHelper.canOpenProject(file2);
    }

    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        return this.myHelper.openProject(virtualFile, projectToClose, forceOpenInNewFrame);
    }

    public boolean isStrongProjectInfoHolder() {
        return true;
    }

    public void refreshProjectFiles(File basedir) {
        File projectDir = basedir.getParentFile();
        File[] projectFiles = projectDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return CidrProjectOpenProcessor.this.myHelper.canOpenProject(name);
            }
        });
        if (projectFiles != null) {
            LocalFileSystem.getInstance().refreshIoFiles(Arrays.asList(projectFiles), false, true, null);
        }
    }
}

