/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ArchitectureType {
    I386("i386"),
    X86_64("x86_64"),
    ARM("arm"),
    PPC("ppc"),
    UNKNOWN("unknown");

    private final String myArchitectureId;

    private ArchitectureType(String architectureId) {
        this.myArchitectureId = architectureId;
    }

    @NotNull
    public static ArchitectureType forArchitecture(@Nullable String arch) {
        if (arch != null) {
            if (arch.contains(I386.getId())) {
                return I386;
            }
            if (arch.contains(X86_64.getId())) {
                return X86_64;
            }
            if (arch.contains(ARM.getId())) {
                return ARM;
            }
            if (arch.contains(PPC.getId())) {
                return PPC;
            }
        }
        return UNKNOWN;
    }

    @NotNull
    public String getId() {
        return this.myArchitectureId;
    }
}

