/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.CheckEmptyTagInspection;
import com.intellij.xml.util.CollapseTagIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckTagEmptyBodyInspection
extends XmlSuppressableInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode node;
                ASTNode child;
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag) && (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) != null && (node = child.getTreeNext()) != null && node.getElementType() == XmlTokenType.XML_END_TAG_START) {
                    Fix localQuickFix = new Fix();
                    holder.registerProblem((PsiElement)tag, XmlBundle.message((String)"xml.inspections.tag.empty.body", (Object[])new Object[0]), new LocalQuickFix[]{CheckTagEmptyBodyInspection.isCollapsibleTag(tag) ? localQuickFix : null});
                }
            }
        };
    }

    static boolean isCollapsibleTag(XmlTag tag) {
        String name = tag.getName().toLowerCase();
        return tag.getLanguage() == XMLLanguage.INSTANCE || "link".equals(name) || "br".equals(name) || "meta".equals(name) || "img".equals(name) || "input".equals(name) || "hr".equals(name);
    }

    @NotNull
    public String getGroupDisplayName() {
        return XmlInspectionGroupNames.XML_INSPECTIONS;
    }

    @NotNull
    public String getDisplayName() {
        return XmlBundle.message((String)"xml.inspections.check.tag.empty.body", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "CheckTagEmptyBody";
    }

    public static class Fix
    extends CollapseTagIntention {
        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            return true;
        }
    }
}

