/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlInspectionGroupNames;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CheckEmptyTagInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.CheckEmptyTagInspection");
    @NonNls
    private static final Set<String> ourTagsWithEmptyEndsNotAllowed = new THashSet(Arrays.asList("script", "div", "iframe"));

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!CheckEmptyTagInspection.isTagWithEmptyEndNotAllowed(tag)) {
                    return;
                }
                ASTNode child = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(tag.getNode());
                if (child == null) {
                    return;
                }
                MyLocalQuickFix fix = new MyLocalQuickFix();
                holder.registerProblem((PsiElement)tag, XmlBundle.message((String)"html.inspections.check.empty.script.message", (Object[])new Object[0]), tag.getContainingFile().getContext() != null ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            }
        };
    }

    static boolean isTagWithEmptyEndNotAllowed(XmlTag tag) {
        String tagName = tag.getName();
        if (tag instanceof HtmlTag) {
            tagName = tagName.toLowerCase();
        }
        Language language = tag.getLanguage();
        return ourTagsWithEmptyEndsNotAllowed.contains(tagName) && language != XMLLanguage.INSTANCE || language.isKindOf((Language)HTMLLanguage.INSTANCE) && !HtmlUtil.isSingleHtmlTagL(tagName) && tagName.indexOf(58) == -1;
    }

    @NotNull
    public String getGroupDisplayName() {
        return XmlInspectionGroupNames.HTML_INSPECTIONS;
    }

    @NotNull
    public String getDisplayName() {
        return XmlBundle.message((String)"html.inspections.check.empty.tag", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "CheckEmptyScriptTag";
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private MyLocalQuickFix() {
        }

        @NotNull
        public String getName() {
            return XmlBundle.message((String)"html.inspections.check.empty.script.tag.fix.message", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            XmlTag tag = (XmlTag)descriptor.getPsiElement();
            if (tag == null) {
                return;
            }
            PsiFile psiFile = tag.getContainingFile();
            if (psiFile == null) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
                return;
            }
            try {
                XmlUtil.expandTag(tag);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }
    }
}

