/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomAttributeXmlDescriptor
implements NamespaceAwareXmlAttributeDescriptor {
    private final DomAttributeChildDescription myDescription;
    private final Project myProject;

    public DomAttributeXmlDescriptor(DomAttributeChildDescription description, Project project2) {
        this.myDescription = description;
        this.myProject = project2;
    }

    public boolean isRequired() {
        Required required = (Required)this.myDescription.getAnnotation(Required.class);
        return required != null && required.value();
    }

    public boolean isFixed() {
        return false;
    }

    public boolean hasIdType() {
        return false;
    }

    public boolean hasIdRefType() {
        return false;
    }

    @Nullable
    public String getDefaultValue() {
        return null;
    }

    public boolean isEnumerated() {
        return false;
    }

    @Nullable
    public String[] getEnumeratedValues() {
        return null;
    }

    @Nullable
    public String validateValue(XmlElement context, String value) {
        return null;
    }

    @Nullable
    public PsiElement getDeclaration() {
        return this.myDescription.getDeclaration(this.myProject);
    }

    @NonNls
    public String getName(PsiElement context) {
        return DomAttributeXmlDescriptor.getQualifiedAttributeName(context, this.myDescription.getXmlName());
    }

    static String getQualifiedAttributeName(PsiElement context, XmlName xmlName) {
        String localName = xmlName.getLocalName();
        if (context instanceof XmlTag) {
            String prefix;
            String ns;
            XmlTag tag = (XmlTag)context;
            DomInvocationHandler handler2 = DomManagerImpl.getDomManager(context.getProject()).getDomHandler((XmlElement)tag);
            if (handler2 != null && !(ns = handler2.createEvaluatedXmlName(xmlName).getNamespace((XmlElement)tag, handler2.getFile())).equals("") && !ns.equals(tag.getNamespace()) && StringUtil.isNotEmpty((String)(prefix = tag.getPrefixByNamespace(ns)))) {
                return prefix + ":" + localName;
            }
        }
        return localName;
    }

    @NonNls
    public String getName() {
        return this.getLocalName();
    }

    private String getLocalName() {
        return this.myDescription.getXmlName().getLocalName();
    }

    @Override
    @Nullable
    public String getNamespace(@NotNull XmlTag context) {
        DomInvocationHandler handler2 = DomManagerImpl.getDomManager(this.myProject).getDomHandler((XmlElement)context);
        if (handler2 == null) {
            return null;
        }
        return handler2.createEvaluatedXmlName(this.myDescription.getXmlName()).getNamespace((XmlElement)context, handler2.getFile());
    }

    public void init(PsiElement element) {
        throw new UnsupportedOperationException("Method init not implemented in " + this.getClass());
    }

    public Object[] getDependences() {
        throw new UnsupportedOperationException("Method getDependences not implemented in " + this.getClass());
    }
}

