/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.config;

import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesAlphaComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.config.ConfigFileSearcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ConfigFilesTreeBuilder {
    private final JTree myTree;
    private static final Comparator<PsiFile> FILE_COMPARATOR = new Comparator<PsiFile>(){

        @Override
        public int compare(PsiFile o1, PsiFile o2) {
            return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
        }
    };

    public ConfigFilesTreeBuilder(JTree tree) {
        this.myTree = tree;
        ConfigFilesTreeBuilder.installSearch(tree);
    }

    public Set<PsiFile> buildTree(DefaultMutableTreeNode root, ConfigFileSearcher ... searchers) {
        HashSet psiFiles = new HashSet();
        MultiMap files = new MultiMap();
        MultiMap jars = new MultiMap();
        MultiMap virtualFiles = new MultiMap();
        for (ConfigFileSearcher searcher : searchers) {
            files.putAllValues(searcher.getFilesByModules());
            jars.putAllValues(searcher.getJars());
            virtualFiles.putAllValues(searcher.getVirtualFiles());
        }
        psiFiles.addAll(this.buildModuleNodes((MultiMap<Module, PsiFile>)files, (MultiMap<VirtualFile, PsiFile>)jars, root));
        for (Map.Entry entry : virtualFiles.entrySet()) {
            DefaultMutableTreeNode node = this.createFileNode(entry.getKey());
            ArrayList list = new ArrayList((Collection)entry.getValue());
            Collections.sort(list, FILE_COMPARATOR);
            for (PsiFile file2 : list) {
                node.add(this.createFileNode(file2));
            }
            root.add(node);
        }
        return psiFiles;
    }

    public DefaultMutableTreeNode addFile(VirtualFile file2) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        DefaultMutableTreeNode treeNode = this.createFileNode(file2);
        root.add(treeNode);
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(root);
        return treeNode;
    }

    public Set<PsiFile> buildModuleNodes(MultiMap<Module, PsiFile> files, MultiMap<VirtualFile, PsiFile> jars, DefaultMutableTreeNode root) {
        java.util.HashSet<PsiFile> psiFiles = new java.util.HashSet<PsiFile>();
        ArrayList modules = new ArrayList(files.keySet());
        Collections.sort(modules, ModulesAlphaComparator.INSTANCE);
        for (Module module2 : modules) {
            DefaultMutableTreeNode moduleNode = this.createFileNode(module2);
            root.add(moduleNode);
            if (!files.containsKey((Object)module2)) continue;
            ArrayList<PsiFile> moduleFiles = new ArrayList<PsiFile>(files.get((Object)module2));
            MultiMap filesByType = new MultiMap();
            for (PsiFile file2 : moduleFiles) {
                filesByType.putValue((Object)file2.getFileType(), (Object)file2);
            }
            if (this.hasNonEmptyGroups((MultiMap<FileType, PsiFile>)filesByType)) {
                for (Map.Entry entry : filesByType.entrySet()) {
                    DefaultMutableTreeNode fileTypeNode = this.createFileNode(entry.getKey());
                    moduleNode.add(fileTypeNode);
                    this.addChildrenFiles(psiFiles, fileTypeNode, new ArrayList<PsiFile>((Collection)entry.getValue()));
                }
                continue;
            }
            this.addChildrenFiles(psiFiles, moduleNode, moduleFiles);
        }
        ArrayList sortedJars = new ArrayList(jars.keySet());
        Collections.sort(sortedJars, new Comparator<VirtualFile>(){

            @Override
            public int compare(VirtualFile o1, VirtualFile o2) {
                return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
            }
        });
        for (VirtualFile file3 : sortedJars) {
            ArrayList list = new ArrayList(jars.get((Object)file3));
            PsiFile jar = ((PsiFile)list.get(0)).getManager().findFile(file3);
            if (jar == null) continue;
            DefaultMutableTreeNode jarNode = this.createFileNode(jar);
            root.add(jarNode);
            Collections.sort(list, FILE_COMPARATOR);
            for (PsiFile psiFile : list) {
                jarNode.add(this.createFileNode(psiFile));
                psiFiles.add(psiFile);
            }
        }
        return psiFiles;
    }

    private static String getFileTypeNodeName(FileType fileType) {
        return fileType.getName() + " context files";
    }

    private boolean hasNonEmptyGroups(MultiMap<FileType, PsiFile> filesByType) {
        int nonEmptyGroups = 0;
        for (Map.Entry entry : filesByType.entrySet()) {
            Collection files = (Collection)entry.getValue();
            if (files == null || files.size() <= 0) continue;
            nonEmptyGroups = (byte)(nonEmptyGroups + 1);
        }
        return nonEmptyGroups > 1;
    }

    private void addChildrenFiles(@NotNull Set<PsiFile> psiFiles, DefaultMutableTreeNode parentNode, @NotNull List<PsiFile> moduleFiles) {
        Collections.sort(moduleFiles, FILE_COMPARATOR);
        for (PsiFile file2 : moduleFiles) {
            DefaultMutableTreeNode fileNode = this.createFileNode(file2);
            parentNode.add(fileNode);
            psiFiles.add(file2);
        }
    }

    protected DefaultMutableTreeNode createFileNode(Object file2) {
        return new DefaultMutableTreeNode(file2);
    }

    public static void renderNode(Object value, boolean expanded, ColoredTreeCellRenderer renderer) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object object = ((DefaultMutableTreeNode)value).getUserObject();
        if (object instanceof FileType) {
            FileType fileType = (FileType)object;
            Icon icon = fileType.getIcon();
            renderer.setIcon(icon);
            renderer.append(ConfigFilesTreeBuilder.getFileTypeNodeName(fileType), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (object instanceof Module) {
            Module module2 = (Module)object;
            Icon icon = ModuleType.get((Module)module2).getIcon();
            renderer.setIcon(icon);
            String moduleName = module2.getName();
            renderer.append(moduleName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (object instanceof PsiFile) {
            PsiFile psiFile = (PsiFile)object;
            Icon icon = psiFile.getIcon(0);
            renderer.setIcon(icon);
            String fileName = psiFile.getName();
            renderer.append(fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                String path = virtualFile.getPath();
                int i = path.indexOf("!/");
                if (i >= 0) {
                    path = path.substring(i + "!/".length());
                }
                renderer.append(" (" + path + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (object instanceof VirtualFile) {
            VirtualFile file2 = (VirtualFile)object;
            renderer.setIcon(VirtualFilePresentation.getIcon((VirtualFile)file2));
            renderer.append(file2.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            String path = file2.getPath();
            int i = path.indexOf("!/");
            if (i >= 0) {
                path = path.substring(i + "!/".length());
            }
            renderer.append(" (" + path + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    public static void installSearch(JTree tree) {
        new TreeSpeedSearch(tree, new Convertor<TreePath, String>(){

            public String convert(TreePath treePath) {
                Object object = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
                if (object instanceof Module) {
                    return ((Module)object).getName();
                }
                if (object instanceof PsiFile) {
                    return ((PsiFile)object).getName();
                }
                if (object instanceof VirtualFile) {
                    return ((VirtualFile)object).getName();
                }
                return "";
            }
        });
    }
}

