/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.breadcrumbs.BreadcrumbsInfoProvider;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlLanguageBreadcrumbsInfoProvider
extends BreadcrumbsInfoProvider {
    public boolean acceptElement(@NotNull PsiElement e) {
        return e instanceof XmlTag && e.isValid();
    }

    public Language[] getLanguages() {
        return new Language[]{XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE, HTMLLanguage.INSTANCE};
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        boolean addHtmlInfo;
        XmlTag tag = (XmlTag)e;
        StringBuilder sb = new StringBuilder();
        sb.append(tag.getName());
        boolean bl = addHtmlInfo = e.getContainingFile().getLanguage() != XMLLanguage.INSTANCE;
        if (addHtmlInfo) {
            String class_value;
            String id_value = tag.getAttributeValue("id");
            if (null != id_value) {
                sb.append("#").append(id_value);
            }
            if (null != (class_value = tag.getAttributeValue("class"))) {
                StringTokenizer tokenizer = new StringTokenizer(class_value, " ");
                while (tokenizer.hasMoreTokens()) {
                    sb.append(".").append(tokenizer.nextToken());
                }
            }
        }
        return sb.toString();
    }

    @Nullable
    public String getElementTooltip(@NotNull PsiElement e) {
        XmlAttribute[] attributes;
        XmlTag tag = (XmlTag)e;
        StringBuilder result = new StringBuilder("&lt;");
        result.append(tag.getName());
        for (XmlAttribute each : attributes = tag.getAttributes()) {
            result.append(" ").append(each.getText());
        }
        if (tag.isEmpty()) {
            result.append("/&gt;");
        } else {
            result.append("&gt;...&lt;/").append(tag.getName()).append("&gt;");
        }
        return result.toString();
    }
}

