/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XValuePresentationUtil {
    public static void renderValue(@NotNull String value, @NotNull ColoredTextContainer text, @NotNull SimpleTextAttributes attributes, int maxLength, @Nullable String additionalCharsToEscape) {
        SimpleTextAttributes escapeAttributes = null;
        int lastOffset = 0;
        int length = maxLength == -1 ? value.length() : Math.min(value.length(), maxLength);
        for (int i = 0; i < length; ++i) {
            char ch = value.charAt(i);
            int additionalCharIndex = -1;
            if (ch != '\n' && ch != '\r' && ch != '\t' && ch != '\b' && ch != '\f' && (additionalCharsToEscape == null || (additionalCharIndex = additionalCharsToEscape.indexOf(ch)) == -1)) continue;
            if (i > lastOffset) {
                text.append(value.substring(lastOffset, i), attributes);
            }
            lastOffset = i + 1;
            if (escapeAttributes == null) {
                TextAttributes fromHighlighter = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
                escapeAttributes = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)fromHighlighter) : new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            }
            if (additionalCharIndex == -1) {
                text.append("\\", escapeAttributes);
            }
            text.append(String.valueOf(XValuePresentationUtil.getEscapingSymbol(ch)), escapeAttributes);
        }
        if (lastOffset < length) {
            text.append(value.substring(lastOffset, length), attributes);
        }
    }

    private static char getEscapingSymbol(char ch) {
        switch (ch) {
            case '\n': {
                return 'n';
            }
            case '\r': {
                return 'r';
            }
            case '\t': {
                return 't';
            }
            case '\b': {
                return 'b';
            }
            case '\f': {
                return 'f';
            }
        }
        return ch;
    }

    public static void appendSeparator(@NotNull ColoredTextContainer text, @NotNull String separator) {
        if (!separator.isEmpty()) {
            text.append(separator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public static String computeValueText(@NotNull XValuePresentation presentation) {
        XValuePresentationTextExtractor extractor = new XValuePresentationTextExtractor();
        presentation.renderValue((XValuePresentation.XValueTextRenderer)extractor);
        return extractor.getText();
    }

    private static class XValuePresentationTextExtractor
    extends XValueTextRendererBase {
        private final StringBuilder myBuilder = new StringBuilder();

        public void renderValue(@NotNull String value) {
            this.myBuilder.append(value);
        }

        @Override
        protected void renderRawValue(@NotNull String value, @NotNull TextAttributesKey key) {
            this.myBuilder.append(value);
        }

        public void renderStringValue(@NotNull String value, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
            this.myBuilder.append(value);
        }

        public void renderComment(@NotNull String comment) {
            this.myBuilder.append(comment);
        }

        public void renderError(@NotNull String error) {
            this.myBuilder.append(error);
        }

        public void renderSpecialSymbol(@NotNull String symbol) {
            this.myBuilder.append(symbol);
        }

        public String getText() {
            return this.myBuilder.toString();
        }
    }
}

