/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueGroupNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XValueContainerNode<ValueContainer extends XValueContainer>
extends XDebuggerTreeNode
implements XCompositeNode,
TreeNode {
    private List<XValueNodeImpl> myValueChildren;
    private List<MessageTreeNode> myMessageChildren;
    private List<MessageTreeNode> myTemporaryMessageChildren;
    private List<XValueGroupNodeImpl> myTopGroups;
    private List<XValueGroupNodeImpl> myBottomGroups;
    private List<TreeNode> myCachedAllChildren;
    protected final ValueContainer myValueContainer;
    private volatile boolean myObsolete;
    private volatile boolean myAlreadySorted;

    protected XValueContainerNode(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull ValueContainer valueContainer) {
        super(tree, parent, true);
        this.myValueContainer = valueContainer;
    }

    private void loadChildren() {
        if (this.myValueChildren != null || this.myMessageChildren != null || this.myTemporaryMessageChildren != null) {
            return;
        }
        this.startComputingChildren();
    }

    public void startComputingChildren() {
        this.myCachedAllChildren = null;
        this.setTemporaryMessageNode(this.createLoadingMessageNode());
        this.myValueContainer.computeChildren((XCompositeNode)this);
    }

    protected MessageTreeNode createLoadingMessageNode() {
        return MessageTreeNode.createLoadingMessage(this.myTree, this);
    }

    public void setAlreadySorted(boolean alreadySorted) {
        this.myAlreadySorted = alreadySorted;
    }

    public void addChildren(final @NotNull XValueChildrenList children2, final boolean last) {
        if (this.myObsolete) {
            return;
        }
        this.invokeNodeUpdate(new Runnable(){

            @Override
            public void run() {
                Object newChildren;
                if (XValueContainerNode.this.myObsolete) {
                    return;
                }
                if (children2.size() > 0) {
                    newChildren = new ArrayList(children2.size());
                    if (XValueContainerNode.this.myValueChildren == null) {
                        if (!XValueContainerNode.this.myAlreadySorted && XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                            XValueContainerNode.this.myValueChildren = (List)new SortedList(XValueNodeImpl.COMPARATOR);
                        } else {
                            XValueContainerNode.this.myValueChildren = new ArrayList(children2.size());
                        }
                    }
                    boolean valuesInline = XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowValuesInline();
                    InlineDebuggerHelper inlineHelper = XValueContainerNode.this.getTree().getEditorsProvider().getInlineDebuggerHelper();
                    for (int i = 0; i < children2.size(); ++i) {
                        XValueNodeImpl node = new XValueNodeImpl(XValueContainerNode.this.myTree, XValueContainerNode.this, children2.getName(i), children2.getValue(i));
                        XValueContainerNode.this.myValueChildren.add(node);
                        newChildren.add(node);
                        if (!valuesInline || !inlineHelper.shouldEvaluateChildrenByDefault((XNamedTreeNode)node) || !XValueContainerNode.isUseGetChildrenHack(XValueContainerNode.this.myTree)) continue;
                        node.getChildren();
                    }
                } else {
                    newChildren = new SmartList();
                    if (XValueContainerNode.this.myValueChildren == null) {
                        XValueContainerNode.this.myValueChildren = (List)new SmartList();
                    }
                }
                XValueContainerNode.this.myTopGroups = XValueContainerNode.this.createGroupNodes(children2.getTopGroups(), XValueContainerNode.this.myTopGroups, (List)newChildren);
                XValueContainerNode.this.myBottomGroups = XValueContainerNode.this.createGroupNodes(children2.getBottomGroups(), XValueContainerNode.this.myBottomGroups, (List)newChildren);
                XValueContainerNode.this.myCachedAllChildren = null;
                XValueContainerNode.this.fireNodesInserted((Collection<? extends TreeNode>)newChildren);
                if (last && XValueContainerNode.this.myTemporaryMessageChildren != null) {
                    int[] ints = XValueContainerNode.this.getNodesIndices(XValueContainerNode.this.myTemporaryMessageChildren);
                    TreeNode[] removed = XValueContainerNode.this.myTemporaryMessageChildren.toArray(new TreeNode[XValueContainerNode.this.myTemporaryMessageChildren.size()]);
                    XValueContainerNode.this.myCachedAllChildren = null;
                    XValueContainerNode.this.myTemporaryMessageChildren = null;
                    XValueContainerNode.this.fireNodesRemoved(ints, removed);
                }
                XValueContainerNode.this.myTree.childrenLoaded(XValueContainerNode.this, (List<XValueContainerNode<?>>)newChildren, last);
            }
        });
    }

    private static boolean isUseGetChildrenHack(@NotNull XDebuggerTree tree) {
        return !tree.isUnderRemoteDebug();
    }

    @Nullable
    private List<XValueGroupNodeImpl> createGroupNodes(List<XValueGroup> groups, @Nullable List<XValueGroupNodeImpl> prevNodes, List<XValueContainerNode<?>> newChildren) {
        if (groups.isEmpty()) {
            return prevNodes;
        }
        SmartList nodes = prevNodes != null ? prevNodes : new SmartList();
        for (XValueGroup group : groups) {
            XValueGroupNodeImpl node = new XValueGroupNodeImpl(this.myTree, (XDebuggerTreeNode)this, group);
            nodes.add(node);
            newChildren.add(node);
        }
        return nodes;
    }

    public void tooManyChildren(final int remaining) {
        this.invokeNodeUpdate(new Runnable(){

            @Override
            public void run() {
                XValueContainerNode.this.setTemporaryMessageNode(MessageTreeNode.createEllipsisNode(XValueContainerNode.this.myTree, XValueContainerNode.this, remaining));
            }
        });
    }

    public boolean isObsolete() {
        return this.myObsolete;
    }

    @Override
    public void clearChildren() {
        this.myCachedAllChildren = null;
        this.myMessageChildren = null;
        this.myTemporaryMessageChildren = null;
        this.myValueChildren = null;
        this.myTopGroups = null;
        this.myBottomGroups = null;
        this.fireNodeStructureChanged();
    }

    public void setErrorMessage(@NotNull String errorMessage) {
        this.setErrorMessage(errorMessage, null);
    }

    public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
        this.setMessage(errorMessage, XDebuggerUIConstants.ERROR_MESSAGE_ICON, XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES, link);
    }

    public void setMessage(final @NotNull String message, final Icon icon, final @NotNull SimpleTextAttributes attributes, final @Nullable XDebuggerTreeNodeHyperlink link) {
        this.invokeNodeUpdate(new Runnable(){

            @Override
            public void run() {
                XValueContainerNode.this.setMessageNodes(MessageTreeNode.createMessages(XValueContainerNode.this.myTree, XValueContainerNode.this, message, link, icon, attributes), false);
            }
        });
    }

    private void setTemporaryMessageNode(MessageTreeNode messageNode) {
        this.setMessageNodes(Collections.singletonList(messageNode), true);
    }

    private void setMessageNodes(List<MessageTreeNode> messages, boolean temporary) {
        this.myCachedAllChildren = null;
        List allMessageChildren = ContainerUtil.concat(this.myMessageChildren != null ? this.myMessageChildren : Collections.emptyList(), this.myTemporaryMessageChildren != null ? this.myTemporaryMessageChildren : Collections.emptyList());
        int[] indices = this.getNodesIndices(allMessageChildren);
        TreeNode[] nodes = allMessageChildren.toArray(new TreeNode[allMessageChildren.size()]);
        this.fireNodesRemoved(indices, nodes);
        if (!temporary) {
            this.myMessageChildren = messages;
            this.myTemporaryMessageChildren = null;
        } else {
            this.myTemporaryMessageChildren = messages;
            this.myMessageChildren = null;
        }
        this.myCachedAllChildren = null;
        this.fireNodesInserted(messages);
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        this.loadChildren();
        if (this.myCachedAllChildren == null) {
            this.myCachedAllChildren = new ArrayList<TreeNode>();
            if (this.myMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myMessageChildren);
            }
            if (this.myTopGroups != null) {
                this.myCachedAllChildren.addAll(this.myTopGroups);
            }
            if (this.myValueChildren != null) {
                this.myCachedAllChildren.addAll(this.myValueChildren);
            }
            if (this.myBottomGroups != null) {
                this.myCachedAllChildren.addAll(this.myBottomGroups);
            }
            if (this.myTemporaryMessageChildren != null) {
                this.myCachedAllChildren.addAll(this.myTemporaryMessageChildren);
            }
        }
        return this.myCachedAllChildren;
    }

    @NotNull
    public ValueContainer getValueContainer() {
        return this.myValueContainer;
    }

    @Nullable
    public List<? extends XValueContainerNode<?>> getLoadedChildren() {
        List empty = Collections.emptyList();
        return ContainerUtil.concat((List[])new List[]{(List)ObjectUtils.notNull(this.myTopGroups, empty), (List)ObjectUtils.notNull(this.myValueChildren, empty), (List)ObjectUtils.notNull(this.myBottomGroups, empty)});
    }

    public void setObsolete() {
        this.myObsolete = true;
    }
}

