/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class XStackFrameNode
extends XValueContainerNode<XStackFrame> {
    public XStackFrameNode(@NotNull XDebuggerTree tree, @NotNull XStackFrame xStackFrame) {
        super(tree, null, xStackFrame);
        this.setLeaf(false);
    }

    @Override
    public void startComputingChildren() {
        if (Registry.is((String)"debugger.watches.in.variables")) {
            XDebugSession session = XDebugView.getSession((Component)((Object)this.getTree()));
            XDebuggerEvaluator evaluator = ((XStackFrame)this.getValueContainer()).getEvaluator();
            if (session != null && evaluator != null) {
                XExpression[] expressions;
                XDebugSessionData data = ((XDebugSessionImpl)session).getSessionData();
                for (final XExpression expression : expressions = data.getWatchExpressions()) {
                    evaluator.evaluate(expression, new XDebuggerEvaluator.XEvaluationCallback(){

                        public void evaluated(@NotNull XValue result) {
                            XStackFrameNode.this.addChildren(XValueChildrenList.singleton((String)expression.getExpression(), (XValue)result), false);
                        }

                        public void errorOccurred(@NotNull String errorMessage) {
                        }
                    }, ((XStackFrame)this.getValueContainer()).getSourcePosition());
                }
            }
        }
        super.startComputingChildren();
    }
}

