/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.event.HyperlinkListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageTreeNode
extends XDebuggerTreeNode {
    private final boolean myEllipsis;
    private XDebuggerTreeNodeHyperlink myLink;

    private MessageTreeNode(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon) {
        this(tree, parent, message, attributes, icon, null);
    }

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon, XDebuggerTreeNodeHyperlink link) {
        this(tree, parent, message, attributes, icon, false, link);
    }

    private MessageTreeNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, SimpleTextAttributes attributes, @Nullable Icon icon, boolean ellipsis, XDebuggerTreeNodeHyperlink link) {
        super(tree, parent, true);
        this.myEllipsis = ellipsis;
        this.myLink = link;
        this.setIcon(icon);
        this.myText.append(message, attributes);
    }

    protected MessageTreeNode(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent, boolean leaf) {
        super(tree, parent, leaf);
        this.myEllipsis = false;
    }

    @Override
    @NotNull
    public List<? extends TreeNode> getChildren() {
        return Collections.emptyList();
    }

    public boolean isEllipsis() {
        return this.myEllipsis;
    }

    @Override
    @Nullable
    protected XDebuggerTreeNodeHyperlink getLink() {
        return this.myLink;
    }

    @Override
    public List<? extends XDebuggerTreeNode> getLoadedChildren() {
        return null;
    }

    @Override
    public void clearChildren() {
    }

    public static MessageTreeNode createEllipsisNode(XDebuggerTree tree, XDebuggerTreeNode parent, int remaining) {
        String message = remaining == -1 ? XDebuggerBundle.message((String)"node.text.ellipsis.0.unknown.more.nodes.double.click.to.show", (Object[])new Object[0]) : XDebuggerBundle.message((String)"node.text.ellipsis.0.more.nodes.double.click.to.show", (Object[])new Object[]{remaining});
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.GRAYED_ATTRIBUTES, null, true, null);
    }

    public static MessageTreeNode createMessageNode(XDebuggerTree tree, XDebuggerTreeNode parent, String message, @Nullable Icon icon) {
        return new MessageTreeNode(tree, parent, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, icon);
    }

    public static MessageTreeNode createLoadingMessage(XDebuggerTree tree, XDebuggerTreeNode parent) {
        return new MessageTreeNode(tree, parent, XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static MessageTreeNode createEvaluatingMessage(XDebuggerTree tree, @Nullable XDebuggerTreeNode parent) {
        return new MessageTreeNode(tree, parent, XDebuggerUIConstants.EVALUATING_EXPRESSION_MESSAGE, XDebuggerUIConstants.EVALUATING_EXPRESSION_HIGHLIGHT_ATTRIBUTES, null);
    }

    public static List<MessageTreeNode> createMessages(XDebuggerTree tree, XDebuggerTreeNode parent, @NotNull String errorMessage, XDebuggerTreeNodeHyperlink link, Icon icon, SimpleTextAttributes attributes) {
        SmartList messages = new SmartList();
        List lines = StringUtil.split((String)errorMessage, (String)"\n", (boolean)true, (boolean)false);
        for (int i = 0; i < lines.size(); ++i) {
            messages.add(new MessageTreeNode(tree, parent, (String)lines.get(i), attributes, icon, (XDebuggerTreeNodeHyperlink)(i == lines.size() - 1 ? link : null)));
        }
        return messages;
    }

    public static MessageTreeNode createInfoMessage(XDebuggerTree tree, @NotNull String message) {
        return MessageTreeNode.createInfoMessage(tree, message, null);
    }

    public static MessageTreeNode createInfoMessage(XDebuggerTree tree, @NotNull String message, @Nullable HyperlinkListener hyperlinkListener) {
        Matcher matcher = MessageTreeNodeWithLinks.HREF_PATTERN.matcher(message);
        if (hyperlinkListener == null || !matcher.find()) {
            return new MessageTreeNode(tree, null, message, SimpleTextAttributes.REGULAR_ATTRIBUTES, XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        int prev = 0;
        do {
            if (matcher.start() != prev) {
                objects.add(message.substring(prev, matcher.start()));
            }
            objects.add((Object)new HyperlinkListenerDelegator(matcher.group(2), matcher.group(1), hyperlinkListener));
            prev = matcher.end();
        } while (matcher.find());
        if (prev < message.length()) {
            objects.add(message.substring(prev));
        }
        return new MessageTreeNodeWithLinks(tree, objects);
    }

    public static final class HyperlinkListenerDelegator
    extends XDebuggerTreeNodeHyperlink {
        private final HyperlinkListener hyperlinkListener;
        private final String href;

        public HyperlinkListenerDelegator(@NotNull String linkText, @Nullable String href, @NotNull HyperlinkListener hyperlinkListener) {
            super(linkText);
            this.hyperlinkListener = hyperlinkListener;
            this.href = href;
        }

        public void onClick(MouseEvent event) {
            this.hyperlinkListener.hyperlinkUpdate(IJSwingUtilities.createHyperlinkEvent(this.href, this.getLinkText()));
        }
    }

    private static class MessageTreeNodeWithLinks
    extends MessageTreeNode {
        private static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");
        private final List<Object> objects;

        private MessageTreeNodeWithLinks(XDebuggerTree tree, List<Object> objects) {
            super(tree, null, true);
            this.setIcon(XDebuggerUIConstants.INFORMATION_MESSAGE_ICON);
            this.objects = objects;
        }

        @Override
        public void appendToComponent(@NotNull ColoredTextContainer component) {
            for (Object object : this.objects) {
                if (object instanceof String) {
                    component.append((String)object, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    continue;
                }
                XDebuggerTreeNodeHyperlink hyperlink = (XDebuggerTreeNodeHyperlink)object;
                component.append(hyperlink.getLinkText(), SimpleTextAttributes.LINK_ATTRIBUTES, (Object)hyperlink);
            }
        }
    }
}

