/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerTreeActionBase
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        String nodeName;
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        if (node != null && (nodeName = node.getName()) != null) {
            this.perform(node, nodeName, e);
        }
    }

    protected abstract void perform(XValueNodeImpl var1, @NotNull String var2, AnActionEvent var3);

    public void update(AnActionEvent e) {
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        e.getPresentation().setEnabled(node != null && this.isEnabled(node, e));
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        return node.getName() != null;
    }

    @NotNull
    public static List<XValueNodeImpl> getSelectedNodes(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        if (tree == null) {
            return Collections.emptyList();
        }
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<XValueNodeImpl> nodes = new ArrayList<XValueNodeImpl>(paths.length);
        for (TreePath path : paths) {
            Object component = path.getLastPathComponent();
            if (!(component instanceof XValueNodeImpl)) continue;
            nodes.add((XValueNodeImpl)component);
        }
        return nodes;
    }

    @Nullable
    public static XValueNodeImpl getSelectedNode(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        return node instanceof XValueNodeImpl ? (XValueNodeImpl)node : null;
    }

    @Nullable
    public static XValue getSelectedValue(@NotNull DataContext dataContext) {
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(dataContext);
        return node != null ? (XValue)node.getValueContainer() : null;
    }
}

