/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerTreePanel
implements DnDSource {
    private final XDebuggerTree myTree;
    private final JPanel myMainPanel;

    public XDebuggerTreePanel(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @NotNull Disposable parentDisposable, @Nullable XSourcePosition sourcePosition, @NotNull @NonNls String popupActionGroupId, @Nullable XValueMarkers<?, ?> markers) {
        this.myTree = new XDebuggerTree(project2, editorsProvider, sourcePosition, popupActionGroupId, markers);
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree)), "Center");
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myTree);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                XDebuggerTreePanel.this.myMainPanel.removeAll();
            }
        });
    }

    public XDebuggerTree getTree() {
        return this.myTree;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
        return this.getNodesToDrag().length > 0;
    }

    private XValueNodeImpl[] getNodesToDrag() {
        return (XValueNodeImpl[])this.myTree.getSelectedNodes(XValueNodeImpl.class, (Tree.NodeFilter)new Tree.NodeFilter<XValueNodeImpl>(){

            public boolean accept(XValueNodeImpl node) {
                return DebuggerUIUtil.hasEvaluationExpression((XValue)node.getValueContainer());
            }
        });
    }

    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
        return new DnDDragStartBean((Object)this.getNodesToDrag());
    }

    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
        XValueNodeImpl[] nodes = this.getNodesToDrag();
        if (nodes.length == 1) {
            return DnDAwareTree.getDragImage((Tree)this.myTree, nodes[0].getPath(), dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this.myTree, XDebuggerBundle.message((String)"xdebugger.drag.text.0.elements", (Object[])new Object[]{nodes.length}), dragOrigin);
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int gestureModifiers) {
    }
}

