/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XDebugViewSessionListener;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.XWatchesViewImpl;
import com.intellij.xdebugger.impl.ui.DebuggerSessionTabBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.tree.actions.SortValuesToggleAction;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebugSessionTab
extends DebuggerSessionTabBase {
    public static final DataKey<XDebugSessionTab> TAB_KEY = DataKey.create((String)"XDebugSessionTab");
    private XWatchesViewImpl myWatchesView;
    private final List<XDebugView> myViews = new ArrayList<XDebugView>();
    @Nullable
    private XDebugSessionImpl mySession;
    private XDebugSessionData mySessionData;
    private final Runnable myRebuildWatchesRunnable = new Runnable(){

        @Override
        public void run() {
            if (XDebugSessionTab.this.myWatchesView != null && XDebugSessionTab.this.myWatchesView.rebuildNeeded()) {
                XDebugSessionTab.this.myWatchesView.processSessionEvent(XDebugView.SessionEvent.SETTINGS_CHANGED);
            }
        }
    };

    @NotNull
    public static XDebugSessionTab create(@NotNull XDebugSessionImpl session, @Nullable Icon icon, @Nullable ExecutionEnvironment environment, @Nullable RunContentDescriptor contentToReuse) {
        XDebugSessionTab oldTab;
        JComponent component;
        if (contentToReuse != null && SystemProperties.getBooleanProperty((String)"xdebugger.reuse.session.tab", (boolean)false) && (component = contentToReuse.getComponent()) != null && (oldTab = (XDebugSessionTab)TAB_KEY.getData(DataManager.getInstance().getDataContext((Component)component))) != null) {
            oldTab.setSession(session, environment, icon);
            oldTab.attachToSession(session);
            return oldTab;
        }
        return new XDebugSessionTab(session, icon, environment);
    }

    @NotNull
    public RunnerLayoutUi getUi() {
        return this.myUi;
    }

    private XDebugSessionTab(@NotNull XDebugSessionImpl session, @Nullable Icon icon, @Nullable ExecutionEnvironment environment) {
        super(session.getProject(), "Debug", session.getSessionName(), GlobalSearchScope.allScope((Project)session.getProject()));
        this.setSession(session, environment, icon);
        this.myUi.addContent(this.createFramesContent(), 0, PlaceInGrid.left, false);
        this.myUi.addContent(this.createVariablesContent(session), 0, PlaceInGrid.center, false);
        this.myUi.addContent(this.createWatchesContent(session), 0, PlaceInGrid.right, false);
        for (XDebugView view : this.myViews) {
            Disposer.register((Disposable)this.myRunContentDescriptor, (Disposable)view);
        }
        this.attachToSession(session);
        DefaultActionGroup focus = new DefaultActionGroup();
        focus.add(ActionManager.getInstance().getAction("Debugger.FocusOnBreakpoint"));
        this.myUi.getOptions().setAdditionalFocusActions((ActionGroup)focus);
        this.myUi.addListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                Content content = event.getContent();
                XDebugSessionImpl session = XDebugSessionTab.this.mySession;
                if (session != null && content.isSelected() && "WatchesContent".equals(ViewImpl.ID.get((UserDataHolder)content))) {
                    XDebugSessionTab.this.myRebuildWatchesRunnable.run();
                }
            }
        }, (Disposable)this.myRunContentDescriptor);
        this.rebuildViews();
    }

    private void setSession(@NotNull XDebugSessionImpl session, @Nullable ExecutionEnvironment environment, @Nullable Icon icon) {
        this.myEnvironment = environment;
        this.mySession = session;
        this.mySessionData = session.getSessionData();
        this.myConsole = session.getConsoleView();
        List<AnAction> restartActionsList = session.getRestartActions();
        AnAction[] restartActions = ContainerUtil.isEmpty(restartActionsList) ? AnAction.EMPTY_ARRAY : restartActionsList.toArray(new AnAction[restartActionsList.size()]);
        this.myRunContentDescriptor = new RunContentDescriptor(this.myConsole, session.getDebugProcess().getProcessHandler(), this.myUi.getComponent(), session.getSessionName(), icon, this.myRebuildWatchesRunnable, restartActions);
        Disposer.register((Disposable)this.myRunContentDescriptor, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myRunContentDescriptor);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (XWatchesView.DATA_KEY.is(dataId)) {
            return this.myWatchesView;
        }
        if (TAB_KEY.is(dataId)) {
            return this;
        }
        if (XDebugSessionData.DATA_KEY.is(dataId)) {
            return this.mySessionData;
        }
        if (this.mySession != null) {
            if (XDebugSession.DATA_KEY.is(dataId)) {
                return this.mySession;
            }
            if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                return this.mySession.getConsoleView();
            }
        }
        return super.getData(dataId);
    }

    private Content createVariablesContent(@NotNull XDebugSessionImpl session) {
        XVariablesView variablesView = new XVariablesView(session);
        this.myViews.add(variablesView);
        Content result = this.myUi.createContent("VariablesContent", variablesView.getPanel(), XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]), AllIcons.Debugger.Value, null);
        result.setCloseable(false);
        ActionGroup group = XDebugSessionTab.getCustomizedActionGroup("XDebugger.Variables.Tree.Toolbar");
        result.setActions(group, "DebuggerToolbar", (JComponent)((Object)variablesView.getTree()));
        return result;
    }

    private Content createWatchesContent(@NotNull XDebugSessionImpl session) {
        this.myWatchesView = new XWatchesViewImpl(session);
        this.myViews.add(this.myWatchesView);
        Content watchesContent = this.myUi.createContent("WatchesContent", (JComponent)this.myWatchesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.watches.title", (Object[])new Object[0]), AllIcons.Debugger.Watches, null);
        watchesContent.setCloseable(false);
        return watchesContent;
    }

    @NotNull
    private Content createFramesContent() {
        XFramesView framesView = new XFramesView(this.myProject);
        this.myViews.add(framesView);
        Content framesContent = this.myUi.createContent("FrameContent", (JComponent)framesView.getMainPanel(), XDebuggerBundle.message((String)"debugger.session.tab.frames.title", (Object[])new Object[0]), AllIcons.Debugger.Frame, null);
        framesContent.setCloseable(false);
        return framesContent;
    }

    public void rebuildViews() {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, new Runnable(){

            @Override
            public void run() {
                for (XDebugView view : XDebugSessionTab.this.myViews) {
                    view.processSessionEvent(XDebugView.SessionEvent.SETTINGS_CHANGED);
                }
            }
        });
    }

    public XWatchesView getWatchesView() {
        return this.myWatchesView;
    }

    private void attachToSession(@NotNull XDebugSessionImpl session) {
        for (XDebugView view : this.myViews) {
            session.addSessionListener((XDebugSessionListener)new XDebugViewSessionListener(view), (Disposable)this.myRunContentDescriptor);
        }
        XDebugTabLayouter layouter = session.getDebugProcess().createTabLayouter();
        Content consoleContent = layouter.registerConsoleContent(this.myUi, this.myConsole);
        this.attachNotificationTo(consoleContent);
        layouter.registerAdditionalContent(this.myUi);
        RunContentBuilder.addAdditionalConsoleEditorActions(this.myConsole, consoleContent);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        DefaultActionGroup leftToolbar = new DefaultActionGroup();
        Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
        if (this.myEnvironment != null) {
            leftToolbar.add(ActionManager.getInstance().getAction("Rerun"));
            List<AnAction> additionalRestartActions = session.getRestartActions();
            if (!additionalRestartActions.isEmpty()) {
                leftToolbar.addAll((Collection)additionalRestartActions);
                leftToolbar.addSeparator();
            }
            leftToolbar.addAll(session.getExtraActions());
        }
        leftToolbar.addAll(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.LeftToolbar"));
        for (AnAction action : session.getExtraStopActions()) {
            leftToolbar.add(action, new Constraints(Anchor.AFTER, "Stop"));
        }
        leftToolbar.addSeparator();
        leftToolbar.add(this.myUi.getOptions().getLayoutActions());
        AnAction[] commonSettings = this.myUi.getOptions().getSettingsActionsList();
        DefaultActionGroup settings = new DefaultActionGroup(ActionsBundle.message((String)"group.XDebugger.settings.text", (Object[])new Object[0]), true);
        settings.getTemplatePresentation().setIcon(this.myUi.getOptions().getSettingsActions().getTemplatePresentation().getIcon());
        settings.addAll(commonSettings);
        leftToolbar.add((AnAction)settings);
        leftToolbar.addSeparator();
        leftToolbar.add(PinToolwindowTabAction.getPinAction());
        leftToolbar.add((AnAction)new CloseAction(this.myEnvironment != null ? this.myEnvironment.getExecutor() : debugExecutor, this.myRunContentDescriptor, this.myProject));
        leftToolbar.add((AnAction)new ContextHelpAction(debugExecutor.getHelpId()));
        DefaultActionGroup topToolbar = new DefaultActionGroup();
        topToolbar.addAll(XDebugSessionTab.getCustomizedActionGroup("XDebugger.ToolWindow.TopToolbar"));
        session.getDebugProcess().registerAdditionalActions(leftToolbar, topToolbar, settings);
        this.myUi.getOptions().setLeftToolbar((ActionGroup)leftToolbar, "DebuggerToolbar");
        this.myUi.getOptions().setTopToolbar((ActionGroup)topToolbar, "DebuggerToolbar");
        if (this.myEnvironment != null) {
            this.initLogConsoles(this.myEnvironment.getRunProfile(), this.myRunContentDescriptor, this.myConsole);
        }
    }

    public void detachFromSession() {
        assert (this.mySession != null);
        this.mySession = null;
    }

    @Nullable
    public RunContentDescriptor getRunContentDescriptor() {
        return this.myRunContentDescriptor;
    }

    private static class ToggleSortValuesAction
    extends SortValuesToggleAction {
        private final boolean myShowIcon;

        private ToggleSortValuesAction(boolean showIcon) {
            this.copyFrom(ActionManager.getInstance().getAction("XDebugger.ToggleSortValues"));
            this.myShowIcon = showIcon;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            if (!this.myShowIcon) {
                e.getPresentation().setIcon(null);
            }
        }
    }
}

