/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.settings.GeneralConfigurableUi;
import com.intellij.xdebugger.impl.settings.XDebuggerGeneralSettings;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class XDebuggerConfigurableProvider
extends DebuggerConfigurableProvider {
    XDebuggerConfigurableProvider() {
    }

    @NotNull
    public Collection<? extends Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        SmartList list = category == DebuggerSettingsCategory.GENERAL ? new SmartList((Object)SimpleConfigurable.create((String)"debugger.general", (String)"", GeneralConfigurableUi.class, (Getter)new Getter<XDebuggerGeneralSettings>(){

            public XDebuggerGeneralSettings get() {
                return XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings();
            }
        })) : null;
        for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            Collection configurables = settings.createConfigurables(category);
            if (configurables.isEmpty()) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.addAll(configurables);
        }
        if (category == DebuggerSettingsCategory.ROOT) {
            for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
                Configurable configurable = settings.createConfigurable();
                if (configurable == null) continue;
                if (list == null) {
                    list = new SmartList();
                }
                list.add(configurable);
            }
        }
        return ContainerUtil.notNullize((List)list);
    }

    public void generalApplied(@NotNull DebuggerSettingsCategory category) {
        for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            settings.generalApplied(category);
        }
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        for (XDebuggerSettings<?> settings : XDebuggerSettingManagerImpl.getInstanceImpl().getSettingsList()) {
            if (!settings.isTargetedToProduct(configurable)) continue;
            return true;
        }
        return super.isTargetedToProduct(configurable);
    }
}

