/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MergedCompositeConfigurable
implements SearchableConfigurable {
    static final EmptyBorder BOTTOM_INSETS = new EmptyBorder(0, 0, 10, 0);
    private static final Insets FIRST_COMPONENT_INSETS = new Insets(0, 0, 10, 0);
    private static final Insets N_COMPONENT_INSETS = new Insets(7, 0, 10, 0);
    protected final Configurable[] children;
    protected JComponent rootComponent;
    private final String id;
    private final String displayName;

    public MergedCompositeConfigurable(@NotNull String id, @NotNull String displayName, @NotNull Configurable[] children2) {
        this.children = children2;
        this.id = id;
        this.displayName = displayName;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nls
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public String getHelpTopic() {
        return this.children.length == 1 ? this.children[0].getHelpTopic() : null;
    }

    protected boolean isUseTargetedProductPolicyIfSeveralChildren() {
        return false;
    }

    @Nullable
    public JComponent createComponent() {
        if (this.rootComponent == null) {
            Configurable firstConfigurable = this.children[0];
            if (this.children.length == 1) {
                this.rootComponent = firstConfigurable.createComponent();
                String rootComponentDisplayName = firstConfigurable.getDisplayName();
                if (!StringUtil.isEmpty((String)rootComponentDisplayName) && !MergedCompositeConfigurable.isTargetedToProduct(firstConfigurable)) {
                    this.rootComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)rootComponentDisplayName, (boolean)false, (Insets)FIRST_COMPONENT_INSETS));
                }
            } else {
                boolean isFirstNamed = true;
                JPanel panel = MergedCompositeConfigurable.createPanel(true);
                for (Configurable configurable : this.children) {
                    JComponent component = configurable.createComponent();
                    assert (component != null);
                    String displayName = configurable.getDisplayName();
                    if (StringUtil.isEmpty((String)displayName)) {
                        component.setBorder(BOTTOM_INSETS);
                    } else {
                        boolean addBorder = true;
                        if (this.isUseTargetedProductPolicyIfSeveralChildren() && isFirstNamed) {
                            isFirstNamed = false;
                            if (MergedCompositeConfigurable.isTargetedToProduct(configurable)) {
                                addBorder = false;
                            }
                        }
                        if (addBorder) {
                            component.setBorder((Border)IdeBorderFactory.createTitledBorder((String)displayName, (boolean)false, (Insets)(firstConfigurable == configurable ? FIRST_COMPONENT_INSETS : N_COMPONENT_INSETS)));
                        }
                    }
                    panel.add(component);
                }
                this.rootComponent = panel;
            }
        }
        return this.rootComponent;
    }

    static boolean isTargetedToProduct(@NotNull Configurable configurable) {
        for (DebuggerConfigurableProvider provider : (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions()) {
            if (!provider.isTargetedToProduct(configurable)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    static JPanel createPanel(boolean isUseTitledBorder) {
        int verticalGap = 7;
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, isUseTitledBorder ? 0 : verticalGap, true, true));
        if (!isUseTitledBorder) {
            panel.setBorder(new EmptyBorder(-verticalGap, 0, 0, 0));
        }
        return panel;
    }

    public boolean isModified() {
        for (Configurable child : this.children) {
            if (!child.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable child : this.children) {
            if (!child.isModified()) continue;
            child.apply();
        }
    }

    public void reset() {
        for (Configurable child : this.children) {
            child.reset();
        }
    }

    public void disposeUIResources() {
        this.rootComponent = null;
        for (Configurable child : this.children) {
            child.disposeUIResources();
        }
    }
}

