/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class XWatchesTreeActionBase
extends AnAction {
    @NotNull
    public static <T extends TreeNode> List<? extends T> getSelectedNodes(@NotNull XDebuggerTree tree, Class<T> nodeClass) {
        ArrayList<T> list = new ArrayList<T>();
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                Object element = selectionPath.getLastPathComponent();
                if (!nodeClass.isInstance(element)) continue;
                list.add(nodeClass.cast(element));
            }
        }
        return list;
    }

    public void update(AnActionEvent e) {
        XDebuggerTree tree = XDebuggerTree.getTree(e);
        XWatchesView watchesView = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        boolean enabled = tree != null && watchesView != null && this.isEnabled(e, tree);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(AnActionEvent e) {
        XDebuggerTree tree = XDebuggerTree.getTree(e);
        XWatchesView watchesView = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        if (tree != null && watchesView != null) {
            this.perform(e, tree, watchesView);
        }
    }

    protected abstract void perform(@NotNull AnActionEvent var1, @NotNull XDebuggerTree var2, @NotNull XWatchesView var3);

    protected boolean isEnabled(@NotNull AnActionEvent e, @NotNull XDebuggerTree tree) {
        return true;
    }
}

