/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ObjectLongHashMap;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.evaluate.quick.XValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XStackFrameNode;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XVariablesViewBase
extends XDebugView {
    protected final XDebuggerTreePanel myDebuggerTreePanel;
    private XDebuggerTreeState myTreeState;
    private Object myFrameEqualityObject;
    private XDebuggerTreeRestorer myTreeRestorer;
    private MySelectionListener mySelectionListener;

    protected XVariablesViewBase(@NotNull Project project2, @NotNull XDebuggerEditorsProvider editorsProvider, @Nullable XValueMarkers<?, ?> markers) {
        this.myDebuggerTreePanel = new XDebuggerTreePanel(project2, editorsProvider, this, null, "XDebugger.Variables.Tree.Popup", markers);
        this.myDebuggerTreePanel.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.variables.not.available", (Object[])new Object[0]));
        DnDManager.getInstance().registerSource((DnDSource)this.myDebuggerTreePanel, (JComponent)((Object)this.myDebuggerTreePanel.getTree()));
    }

    protected void buildTreeAndRestoreState(@NotNull XStackFrame stackFrame) {
        XDebuggerTree tree = this.myDebuggerTreePanel.getTree();
        XSourcePosition position = stackFrame.getSourcePosition();
        tree.setSourcePosition(position);
        tree.setRoot(new XStackFrameNode(tree, stackFrame), false);
        Project project2 = tree.getProject();
        project2.putUserData(XVariablesView.DEBUG_VARIABLES, (Object)new XVariablesView.InlineVariablesInfo());
        project2.putUserData(XVariablesView.DEBUG_VARIABLES_TIMESTAMPS, (Object)new ObjectLongHashMap());
        Object newEqualityObject = stackFrame.getEqualityObject();
        if (this.myFrameEqualityObject != null && newEqualityObject != null && this.myFrameEqualityObject.equals(newEqualityObject) && this.myTreeState != null) {
            this.disposeTreeRestorer();
            this.myTreeRestorer = this.myTreeState.restoreState(tree);
        }
        if (position != null && Registry.is((String)"debugger.valueTooltipAutoShowOnSelection")) {
            this.registerInlineEvaluator(stackFrame, position, project2);
        }
    }

    private void registerInlineEvaluator(XStackFrame stackFrame, XSourcePosition position, Project project2) {
        VirtualFile file2 = position.getFile();
        FileEditor fileEditor = FileEditorManagerEx.getInstanceEx(project2).getSelectedEditor(file2);
        if (fileEditor instanceof PsiAwareTextEditorImpl) {
            Editor editor = ((PsiAwareTextEditorImpl)fileEditor).getEditor();
            this.removeSelectionListener();
            this.mySelectionListener = new MySelectionListener(editor, stackFrame, project2);
            editor.getSelectionModel().addSelectionListener((SelectionListener)this.mySelectionListener);
        }
    }

    protected void saveCurrentTreeState(@Nullable XStackFrame stackFrame) {
        this.disposeTreeRestorer();
        this.removeSelectionListener();
        this.myFrameEqualityObject = stackFrame != null ? stackFrame.getEqualityObject() : null;
        this.myTreeState = XDebuggerTreeState.saveState(this.myDebuggerTreePanel.getTree());
    }

    private void removeSelectionListener() {
        if (this.mySelectionListener != null) {
            this.mySelectionListener.remove();
            this.mySelectionListener = null;
        }
    }

    @Override
    protected void clear() {
        this.removeSelectionListener();
    }

    private void disposeTreeRestorer() {
        if (this.myTreeRestorer != null) {
            this.myTreeRestorer.dispose();
            this.myTreeRestorer = null;
        }
    }

    public XDebuggerTree getTree() {
        return this.myDebuggerTreePanel.getTree();
    }

    public JComponent getPanel() {
        return this.myDebuggerTreePanel.getMainPanel();
    }

    public void dispose() {
        this.disposeTreeRestorer();
        this.removeSelectionListener();
        DnDManager.getInstance().unregisterSource((DnDSource)this.myDebuggerTreePanel, (JComponent)((Object)this.myDebuggerTreePanel.getTree()));
    }

    private class MySelectionListener
    implements SelectionListener {
        private final Editor myEditor;
        private final XStackFrame myStackFrame;
        private final Project myProject;

        public MySelectionListener(Editor editor, XStackFrame stackFrame, Project project2) {
            this.myEditor = editor;
            this.myStackFrame = stackFrame;
            this.myProject = project2;
        }

        public void remove() {
            this.myEditor.getSelectionModel().removeSelectionListener((SelectionListener)this);
        }

        public void selectionChanged(SelectionEvent e) {
            if (!Registry.is((String)"debugger.valueTooltipAutoShowOnSelection") || this.myEditor.getCaretModel().getCaretCount() > 1) {
                return;
            }
            String text = this.myEditor.getDocument().getText(e.getNewRange());
            if (!(StringUtil.isEmpty((String)text) || text.contains("exec(") || text.contains("++") || text.contains("--") || text.contains("="))) {
                XDebugSession session = XDebugView.getSession((Component)((Object)XVariablesViewBase.this.getTree()));
                if (session == null) {
                    return;
                }
                XDebuggerEvaluator evaluator = this.myStackFrame.getEvaluator();
                if (evaluator == null) {
                    return;
                }
                TextRange range = e.getNewRange();
                ExpressionInfo info = new ExpressionInfo(range);
                int offset = range.getStartOffset();
                LogicalPosition pos = this.myEditor.offsetToLogicalPosition(offset);
                Point point = this.myEditor.logicalPositionToXY(pos);
                new XValueHint(this.myProject, this.myEditor, point, ValueHintType.MOUSE_OVER_HINT, info, evaluator, session).invokeHint();
            }
        }
    }
}

