/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerFramesList
extends DebuggerFramesList {
    private final Project myProject;
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new TransferHandler(){

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (!(c instanceof XDebuggerFramesList)) {
                return null;
            }
            XDebuggerFramesList list = (XDebuggerFramesList)((Object)c);
            Object[] values = list.getSelectedValues();
            if (values == null || values.length == 0) {
                return null;
            }
            StringBuilder plainBuf = new StringBuilder();
            StringBuilder htmlBuf = new StringBuilder();
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            htmlBuf.append("<html>\n<body>\n<ul>\n");
            for (Object value : values) {
                htmlBuf.append("  <li>");
                if (value != null) {
                    if (value instanceof XStackFrame) {
                        ((XStackFrame)value).customizePresentation((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(plainBuf, htmlBuf);
                    } else {
                        String text = value.toString();
                        plainBuf.append(text);
                        htmlBuf.append(text);
                    }
                }
                plainBuf.append('\n');
                htmlBuf.append("</li>\n");
            }
            plainBuf.setLength(plainBuf.length() - 1);
            htmlBuf.append("</ul>\n</body>\n</html>");
            return new TextTransferable(htmlBuf.toString(), plainBuf.toString());
        }

        @Override
        public int getSourceActions(@NotNull JComponent c) {
            return 1;
        }
    };
    private XStackFrame mySelectedFrame;

    public XDebuggerFramesList(@NotNull Project project2) {
        this.myProject = project2;
        this.doInit();
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
        this.setDataProvider(new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (XDebuggerFramesList.this.mySelectedFrame != null) {
                    VirtualFile file2;
                    if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                        return XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame);
                    }
                    if (CommonDataKeys.PSI_FILE.is(dataId) && (file2 = XDebuggerFramesList.getFile(XDebuggerFramesList.this.mySelectedFrame)) != null && file2.isValid()) {
                        return PsiManager.getInstance((Project)XDebuggerFramesList.this.myProject).findFile(file2);
                    }
                }
                return null;
            }
        });
    }

    @Nullable
    private static VirtualFile getFile(XStackFrame frame) {
        XSourcePosition position = frame.getSourcePosition();
        return position != null ? position.getFile() : null;
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerFrameListRenderer(this.myProject);
    }

    @Override
    protected void onFrameChanged(Object selectedValue) {
        if (this.mySelectedFrame != selectedValue) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    XDebuggerFramesList.this.repaint();
                }
            });
            this.mySelectedFrame = selectedValue instanceof XStackFrame ? (XStackFrame)selectedValue : null;
        }
    }

    private static class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        private final FileColorManager myColorsManager;

        public XDebuggerFrameListRenderer(@NotNull Project project2) {
            this.myColorsManager = FileColorManager.getInstance((Project)project2);
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            Color c;
            VirtualFile virtualFile;
            XSourcePosition position;
            if (UIUtil.isUnderGTKLookAndFeel()) {
                Color background = selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeTextBackground();
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
            }
            if (value == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value;
            if (!selected && (position = stackFrame.getSourcePosition()) != null && (virtualFile = position.getFile()).isValid() && (c = this.myColorsManager.getFileColor(virtualFile)) != null) {
                this.setBackground(c);
            }
            stackFrame.customizePresentation((ColoredTextContainer)this);
        }
    }
}

