/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import java.awt.Component;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebugView
implements Disposable {
    private final SingleAlarm myClearAlarm = new SingleAlarm(new Runnable(){

        @Override
        public void run() {
            XDebugView.this.clear();
        }
    }, 100, this);
    private static final int VIEW_CLEAR_DELAY = 100;

    protected final void requestClear() {
        this.myClearAlarm.cancelAndRequest();
    }

    protected final void cancelClear() {
        this.myClearAlarm.cancel();
    }

    protected abstract void clear();

    public abstract void processSessionEvent(@NotNull SessionEvent var1);

    @Nullable
    protected static XDebugSession getSession(@NotNull EventObject e) {
        Component component = e.getSource() instanceof Component ? (Component)e.getSource() : null;
        return component == null ? null : XDebugView.getSession(component);
    }

    @Nullable
    public static XDebugSession getSession(@NotNull Component component) {
        return (XDebugSession)XDebugView.getData(XDebugSession.DATA_KEY, component);
    }

    @Nullable
    protected VirtualFile getCurrentFile(@NotNull Component component) {
        XSourcePosition position;
        XDebugSession session = XDebugView.getSession(component);
        if (session != null && (position = session.getCurrentPosition()) != null) {
            return position.getFile();
        }
        return null;
    }

    @Nullable
    public static <T> T getData(DataKey<T> key, @NotNull Component component) {
        Object data;
        ContentManager contentManager;
        DataContext dataContext = DataManager.getInstance().getDataContext(component);
        ViewContext viewContext = (ViewContext)ViewContext.CONTEXT_KEY.getData(dataContext);
        ContentManager contentManager2 = contentManager = viewContext == null ? null : viewContext.getContentManager();
        if (contentManager != null && (data = key.getData(DataManager.getInstance().getDataContext((Component)contentManager.getComponent()))) != null) {
            return (T)data;
        }
        return (T)key.getData(dataContext);
    }

    public static enum SessionEvent {
        PAUSED,
        BEFORE_RESUME,
        RESUMED,
        STOPPED,
        FRAME_CHANGED,
        SETTINGS_CHANGED;

    }
}

