/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchInplaceEditor
extends XDebuggerTreeInplaceEditor {
    private final WatchesRootNode myRootNode;
    private final XWatchesView myWatchesView;
    @Nullable
    private final WatchNode myOldNode;
    private WatchEditorSessionListener mySessionListener;

    public WatchInplaceEditor(@NotNull WatchesRootNode rootNode, @Nullable XDebugSession session, XWatchesView watchesView, WatchNode node, @NonNls String historyId, @Nullable WatchNode oldNode) {
        super((XDebuggerTreeNode)((Object)node), historyId);
        this.myRootNode = rootNode;
        this.myWatchesView = watchesView;
        this.myOldNode = oldNode;
        this.myExpressionEditor.setExpression(oldNode != null ? oldNode.getExpression() : null);
        if (session != null) {
            this.mySessionListener = new WatchEditorSessionListener(session).install();
        }
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        return this.myExpressionEditor.getComponent();
    }

    @Override
    public void cancelEditing() {
        if (!this.isShown()) {
            return;
        }
        super.cancelEditing();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (this.myOldNode != null && index != -1) {
            this.myWatchesView.addWatchExpression(this.myOldNode.getExpression(), index, false);
        }
        this.getTree().setSelectionRow(index);
    }

    @Override
    public void doOKAction() {
        XExpression expression = this.myExpressionEditor.getExpression();
        this.myExpressionEditor.saveTextInHistory();
        super.doOKAction();
        int index = this.myRootNode.removeChildNode(this.getNode());
        if (!XDebuggerUtilImpl.isEmptyExpression(expression) && index != -1) {
            this.myWatchesView.addWatchExpression(expression, index, false);
        }
        this.getTree().setSelectionRow(index);
    }

    @Override
    protected void onHidden() {
        super.onHidden();
        if (this.mySessionListener != null) {
            this.mySessionListener.remove();
        }
    }

    private class WatchEditorSessionListener
    extends XDebugSessionAdapter {
        private final XDebugSession mySession;

        public WatchEditorSessionListener(XDebugSession session) {
            this.mySession = session;
        }

        public WatchEditorSessionListener install() {
            this.mySession.addSessionListener((XDebugSessionListener)this);
            return this;
        }

        public void remove() {
            this.mySession.removeSessionListener((XDebugSessionListener)this);
        }

        private void cancel() {
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    WatchInplaceEditor.this.cancelEditing();
                }
            });
        }

        public void sessionPaused() {
            this.cancel();
        }

        public void beforeSessionResume() {
            this.cancel();
        }

        public void sessionResumed() {
            this.cancel();
        }

        public void sessionStopped() {
            this.cancel();
        }
    }
}

