/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.concurrency.ResultConsumer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class XDebuggerInstanceTreeCreator
implements DebuggerTreeCreator<Pair<XInstanceEvaluator, String>> {
    @NotNull
    private final Project myProject;
    private final XDebuggerEditorsProvider myProvider;
    private final XSourcePosition myPosition;
    private final XValueMarkers<?, ?> myMarkers;
    private final XDebugSession mySession;

    public XDebuggerInstanceTreeCreator(@NotNull Project project2, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, XValueMarkers<?, ?> markers, XDebugSession session) {
        this.myProject = project2;
        this.myProvider = editorsProvider;
        this.myPosition = sourcePosition;
        this.myMarkers = markers;
        this.mySession = session;
    }

    @Override
    @NotNull
    public Tree createTree(@NotNull Pair<XInstanceEvaluator, String> descriptor) {
        XDebuggerTree tree = new XDebuggerTree(this.myProject, this.myProvider, this.myPosition, "XDebugger.Inspect.Tree.Popup", this.myMarkers);
        final XValueNodeImpl root = new XValueNodeImpl(tree, null, (String)descriptor.getSecond(), new InstanceEvaluatorTreeRootValue((XInstanceEvaluator)descriptor.getFirst(), (String)descriptor.getSecond()));
        tree.setRoot(root, false);
        Condition<TreeNode> visibleRootCondition = new Condition<TreeNode>(){

            public boolean value(TreeNode node) {
                return node.getParent() == root;
            }
        };
        tree.expandNodesOnLoad(visibleRootCondition);
        tree.selectNodeOnLoad(visibleRootCondition);
        return tree;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Pair<XInstanceEvaluator, String> descriptor) {
        return (String)descriptor.getSecond();
    }

    @Override
    public void createDescriptorByNode(Object node, ResultConsumer<Pair<XInstanceEvaluator, String>> resultConsumer) {
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            resultConsumer.onSuccess((Object)Pair.create((Object)((XValue)valueNode.getValueContainer()).getInstanceEvaluator(), (Object)valueNode.getName()));
        }
    }

    private class InstanceEvaluatorTreeRootValue
    extends XValue {
        private final XInstanceEvaluator myInstanceEvaluator;
        private final String myName;

        public InstanceEvaluatorTreeRootValue(XInstanceEvaluator instanceEvaluator, String name) {
            this.myInstanceEvaluator = instanceEvaluator;
            this.myName = name;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            node.setPresentation(null, null, "root", true);
        }

        public void computeChildren(final @NotNull XCompositeNode node) {
            XStackFrame frame = XDebuggerInstanceTreeCreator.this.mySession.getCurrentStackFrame();
            if (frame != null) {
                this.myInstanceEvaluator.evaluate(new XDebuggerEvaluator.XEvaluationCallback(){

                    public void evaluated(@NotNull XValue result) {
                        node.addChildren(XValueChildrenList.singleton((String)InstanceEvaluatorTreeRootValue.this.myName, (XValue)result), true);
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                    }
                }, frame);
            } else {
                node.setErrorMessage("Frame is not available");
            }
        }
    }
}

