/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.grouping;

import com.intellij.util.ArrayUtil;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class XBreakpointTypeGroup
extends XBreakpointGroup {
    private final XBreakpointType myBreakpointType;

    public XBreakpointTypeGroup(XBreakpointType type) {
        this.myBreakpointType = type;
    }

    @NotNull
    public String getName() {
        return this.myBreakpointType.getTitle();
    }

    public XBreakpointType getBreakpointType() {
        return this.myBreakpointType;
    }

    public Icon getIcon(boolean isOpen) {
        return this.myBreakpointType.getEnabledIcon();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compareTo(XBreakpointGroup o) {
        if (this.getName().equals(o.getName())) {
            return 0;
        }
        if (!(o instanceof XBreakpointTypeGroup)) return -o.compareTo((XBreakpointGroup)this);
        if (((XBreakpointTypeGroup)o).myBreakpointType instanceof XLineBreakpointType) {
            if (!(this.myBreakpointType instanceof XLineBreakpointType)) return 1;
            int res = ((XLineBreakpointType)((XBreakpointTypeGroup)o).myBreakpointType).getPriority() - ((XLineBreakpointType)this.myBreakpointType).getPriority();
            if (res == 0) return XBreakpointTypeGroup.indexOfType(this.myBreakpointType) - XBreakpointTypeGroup.indexOfType(((XBreakpointTypeGroup)o).getBreakpointType());
            return res;
        }
        if (!(this.myBreakpointType instanceof XLineBreakpointType)) return XBreakpointTypeGroup.indexOfType(this.myBreakpointType) - XBreakpointTypeGroup.indexOfType(((XBreakpointTypeGroup)o).getBreakpointType());
        return -1;
    }

    private static int indexOfType(XBreakpointType type) {
        return ArrayUtil.find((Object[])XBreakpointUtil.getBreakpointTypes(), (Object)type);
    }
}

