/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import org.jetbrains.annotations.NotNull;

@Tag(value="line-breakpoint")
public class LineBreakpointState<P extends XBreakpointProperties>
extends BreakpointState<XLineBreakpoint<P>, P, XLineBreakpointType<P>> {
    private String myFileUrl;
    private int myLine;
    private boolean myTemporary;

    public LineBreakpointState() {
    }

    public LineBreakpointState(boolean enabled, String typeId, String fileUrl, int line, boolean temporary, long timeStamp) {
        super(enabled, typeId, timeStamp);
        this.myFileUrl = fileUrl;
        this.myLine = line;
        this.myTemporary = temporary;
    }

    @Tag(value="url")
    public String getFileUrl() {
        return this.myFileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.myFileUrl = fileUrl;
    }

    @Tag(value="line")
    public int getLine() {
        return this.myLine;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    public void setTemporary(boolean temporary) {
        this.myTemporary = temporary;
    }

    @Override
    public XBreakpointBase<XLineBreakpoint<P>, P, ?> createBreakpoint(@NotNull XLineBreakpointType<P> type, @NotNull XBreakpointManagerImpl breakpointManager) {
        return new XLineBreakpointImpl<P>(type, breakpointManager, this);
    }
}

