/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XAddToWatchesFromEditorActionHandler
extends XDebuggerActionHandler {
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session, DataContext dataContext) {
        return XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session) != null;
    }

    @Nullable
    protected static String getTextToEvaluate(DataContext dataContext, XDebugSession session) {
        XDebuggerEvaluator evaluator;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null && (evaluator = session.getDebugProcess().getEvaluator()) != null) {
            text = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, editor.getProject(), editor);
        }
        return StringUtil.nullize((String)text, (boolean)true);
    }

    @Override
    protected void perform(@NotNull XDebugSession session, DataContext dataContext) {
        String text = XAddToWatchesFromEditorActionHandler.getTextToEvaluate(dataContext, session);
        if (text == null) {
            return;
        }
        ((XDebugSessionImpl)session).getSessionTab().getWatchesView().addWatchExpression(XExpressionImpl.fromText(text), -1, true);
    }
}

