/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class MarkObjectAction
extends XDebuggerActionBase {
    @Override
    public void update(AnActionEvent event) {
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        boolean enabled = false;
        Presentation presentation = event.getPresentation();
        boolean hidden = true;
        if (project2 != null) {
            for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
                MarkObjectActionHandler handler2 = support.getMarkObjectHandler();
                hidden &= handler2.isHidden(project2, event);
                if (!handler2.isEnabled(project2, event)) continue;
                enabled = true;
                String text = handler2.isMarked(project2, event) ? ActionsBundle.message((String)"action.Debugger.MarkObject.unmark.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.Debugger.MarkObject.text", (Object[])new Object[0]);
                presentation.setText(text);
                break;
            }
        }
        presentation.setVisible(!hidden && (!ActionPlaces.isPopupPlace((String)event.getPlace()) || enabled));
        presentation.setEnabled(enabled);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        return debuggerSupport.getMarkObjectHandler();
    }
}

