/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.AppTopics;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointAdapter;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugProcessConfiguratorStarter;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.settings.XDebuggerSettingManagerImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements NamedComponent,
PersistentStateComponent<XDebuggerState> {
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerManager";
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final XDebuggerWatchesManager myWatchesManager;
    private final Map<ProcessHandler, XDebugSessionImpl> mySessions;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private final AtomicReference<XDebugSessionImpl> myActiveSession = new AtomicReference();

    public XDebuggerManagerImpl(Project project2, StartupManager startupManager, MessageBus messageBus) {
        this.myProject = project2;
        this.myBreakpointManager = new XBreakpointManagerImpl(project2, this, startupManager);
        this.myWatchesManager = new XDebuggerWatchesManager();
        this.mySessions = new LinkedHashMap<ProcessHandler, XDebugSessionImpl>();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project2);
        MessageBusConnection messageBusConnection = messageBus.connect();
        messageBusConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentLoaded(@NotNull VirtualFile file2, @NotNull Document document) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, true);
            }
        });
        messageBusConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                XDebuggerManagerImpl.this.updateExecutionPoint(file2, false);
            }
        });
        this.myBreakpointManager.addBreakpointListener((XBreakpointListener<XBreakpoint<?>>)new XBreakpointAdapter<XBreakpoint<?>>(){

            public void breakpointChanged(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session;
                if (!(breakpoint instanceof XLineBreakpoint) && (session = XDebuggerManagerImpl.this.getCurrentSession()) != null && breakpoint.equals(session.getActiveNonLineBreakpoint())) {
                    XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
                    breakpointBase.clearIcon();
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(breakpointBase.createGutterIconRenderer());
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint<?> breakpoint) {
                XDebugSessionImpl session = XDebuggerManagerImpl.this.getCurrentSession();
                if (session != null && breakpoint == session.getActiveNonLineBreakpoint()) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.updateGutterIcon(null);
                }
            }
        });
        messageBusConnection.subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (descriptor != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebugSessionImpl session = (XDebugSessionImpl)XDebuggerManagerImpl.this.mySessions.get(descriptor.getProcessHandler());
                    if (session != null) {
                        session.activateSession();
                    } else {
                        XDebuggerManagerImpl.this.setCurrentSession(null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor, @NotNull Executor executor) {
                if (descriptor != null && executor.equals(DefaultDebugExecutor.getDebugExecutorInstance())) {
                    XDebuggerManagerImpl.this.mySessions.remove(descriptor.getProcessHandler());
                }
            }
        });
    }

    private void updateExecutionPoint(@NotNull VirtualFile file2, boolean navigate) {
        if (file2.equals(this.myExecutionPointHighlighter.getCurrentFile())) {
            this.myExecutionPointHighlighter.update(navigate);
        }
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        return this.myBreakpointManager;
    }

    public XDebuggerWatchesManager getWatchesManager() {
        return this.myWatchesManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @NotNull
    public XDebugSession startSession(@NotNull ExecutionEnvironment environment, @NotNull XDebugProcessStarter processStarter) throws ExecutionException {
        return this.startSession(environment.getContentToReuse(), processStarter, new XDebugSessionImpl(environment, this));
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        return this.startSessionAndShowTab(sessionName, contentToReuse, false, starter);
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        return this.startSessionAndShowTab(sessionName, null, contentToReuse, showToolWindowOnSuspendOnly, starter);
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, Icon icon, @Nullable RunContentDescriptor contentToReuse, boolean showToolWindowOnSuspendOnly, @NotNull XDebugProcessStarter starter) throws ExecutionException {
        XDebugSessionImpl session = this.startSession(contentToReuse, starter, new XDebugSessionImpl(null, this, sessionName, icon, showToolWindowOnSuspendOnly));
        if (!showToolWindowOnSuspendOnly) {
            session.showSessionTab();
        }
        ProcessHandler handler2 = session.getDebugProcess().getProcessHandler();
        handler2.startNotify();
        return session;
    }

    private XDebugSessionImpl startSession(@Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter, @NotNull XDebugSessionImpl session) throws ExecutionException {
        JComponent component;
        XDebugProcess process = processStarter.start((XDebugSession)session);
        ((XDebuggerManagerListener)this.myProject.getMessageBus().syncPublisher(TOPIC)).processStarted(process);
        XDebugSessionData oldSessionData = null;
        if (contentToReuse != null && (component = contentToReuse.getComponent()) != null) {
            oldSessionData = (XDebugSessionData)XDebugSessionData.DATA_KEY.getData(DataManager.getInstance().getDataContext((Component)component));
        }
        session.initSessionData(oldSessionData);
        if (processStarter instanceof XDebugProcessConfiguratorStarter) {
            session.activateSession();
            ((XDebugProcessConfiguratorStarter)processStarter).configure(session.getSessionData());
        }
        session.init(process, contentToReuse);
        this.mySessions.put(session.getDebugProcess().getProcessHandler(), session);
        return session;
    }

    public void removeSession(final @NotNull XDebugSessionImpl session) {
        XDebugSessionTab sessionTab = session.getSessionTab();
        this.mySessions.remove(session.getDebugProcess().getProcessHandler());
        if (sessionTab != null) {
            RunContentDescriptor descriptor = sessionTab.getRunContentDescriptor();
            if (descriptor != null) {
                Disposer.register((Disposable)descriptor, (Disposable)new Disposable(){

                    public void dispose() {
                        XDebuggerManagerImpl.this.mySessions.remove(session.getDebugProcess().getProcessHandler());
                    }
                });
            }
            if (!this.myProject.isDisposed() && !ApplicationManager.getApplication().isUnitTestMode() && XDebuggerSettingManagerImpl.getInstanceImpl().getGeneralSettings().isHideDebuggerOnProcessTermination()) {
                ExecutionManager.getInstance((Project)this.myProject).getContentManager().hideRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
            }
        }
        if (this.myActiveSession.compareAndSet(session, null)) {
            this.onActiveSessionChanged();
        }
    }

    void updateExecutionPoint(@Nullable XSourcePosition position, boolean useSelection, @Nullable GutterIconRenderer gutterIconRenderer) {
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, useSelection, gutterIconRenderer);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
    }

    private void onActiveSessionChanged() {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    @NotNull
    public XDebugSession[] getDebugSessions() {
        Collection<XDebugSessionImpl> sessions = this.mySessions.values();
        return sessions.toArray(new XDebugSessionImpl[sessions.size()]);
    }

    @Nullable
    public XDebugSession getDebugSession(@NotNull ExecutionConsole executionConsole) {
        for (XDebugSessionImpl debuggerSession : this.mySessions.values()) {
            RunContentDescriptor contentDescriptor;
            XDebugSessionTab sessionTab = debuggerSession.getSessionTab();
            if (sessionTab == null || (contentDescriptor = sessionTab.getRunContentDescriptor()) == null || executionConsole != contentDescriptor.getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    @NotNull
    public <T extends XDebugProcess> List<? extends T> getDebugProcesses(Class<T> processClass) {
        SmartList list = null;
        for (XDebugSessionImpl session : this.mySessions.values()) {
            XDebugProcess process = session.getDebugProcess();
            if (!processClass.isInstance(process)) continue;
            if (list == null) {
                list = new SmartList();
            }
            list.add(processClass.cast(process));
        }
        return list == null ? Collections.emptyList() : list;
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        return this.myActiveSession.get();
    }

    void setCurrentSession(@Nullable XDebugSessionImpl session) {
        boolean sessionChanged;
        boolean bl = sessionChanged = this.myActiveSession.getAndSet(session) != session;
        if (sessionChanged) {
            if (session != null) {
                XDebugSessionTab tab = session.getSessionTab();
                if (tab != null) {
                    tab.select();
                }
            } else {
                this.myExecutionPointHighlighter.hide();
            }
            this.onActiveSessionChanged();
        }
    }

    public XDebuggerState getState() {
        return new XDebuggerState(this.myBreakpointManager.getState(), this.myWatchesManager.getState());
    }

    public boolean isFullLineHighlighter() {
        return this.myExecutionPointHighlighter.isFullLineHighlighter();
    }

    public void loadState(XDebuggerState state) {
        this.myBreakpointManager.loadState(state.myBreakpointManagerState);
        this.myWatchesManager.loadState(state.myWatchesManagerState);
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    public static class XDebuggerState {
        private XBreakpointManagerImpl.BreakpointManagerState myBreakpointManagerState;
        private XDebuggerWatchesManager.WatchesManagerState myWatchesManagerState;

        public XDebuggerState() {
        }

        public XDebuggerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState, XDebuggerWatchesManager.WatchesManagerState watchesManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
            this.myWatchesManagerState = watchesManagerState;
        }

        @Property(surroundWithTag=false)
        public XBreakpointManagerImpl.BreakpointManagerState getBreakpointManagerState() {
            return this.myBreakpointManagerState;
        }

        public void setBreakpointManagerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
        }

        @Property(surroundWithTag=false)
        public XDebuggerWatchesManager.WatchesManagerState getWatchesManagerState() {
            return this.myWatchesManagerState;
        }

        public void setWatchesManagerState(XDebuggerWatchesManager.WatchesManagerState watchesManagerState) {
            this.myWatchesManagerState = watchesManagerState;
        }
    }
}

