/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class VcsImplUtil {
    public static void showErrorMessage(final Project project2, final String message, final String title) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)project2, (String)message, (String)title);
            }
        };
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task, null, (Project)project2);
    }

    @NotNull
    public static String getShortVcsRootName(@NotNull Project project2, @NotNull VirtualFile root) {
        String relativePath;
        VirtualFile projectDir = project2.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        return repositoryPath.isEmpty() ? root.getName() : repositoryPath;
    }
}

