/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StopWatch {
    private static final Logger LOG = Logger.getInstance(StopWatch.class);
    private final long myStartTime;
    @NotNull
    private final String myOperation;
    @NotNull
    private final Map<VirtualFile, Long> myDurationPerRoot;

    private StopWatch(@NotNull String operation) {
        this.myOperation = operation;
        this.myStartTime = System.currentTimeMillis();
        this.myDurationPerRoot = ContainerUtil.newHashMap();
    }

    @NotNull
    public static StopWatch start(@NotNull String operation) {
        return new StopWatch(operation);
    }

    public void rootCompleted(@NotNull VirtualFile root) {
        long totalDuration = System.currentTimeMillis() - this.myStartTime;
        long duration = totalDuration - StopWatch.sum(this.myDurationPerRoot.values());
        this.myDurationPerRoot.put(root, duration);
    }

    private static long sum(@NotNull Collection<Long> durations) {
        long sum = 0L;
        for (Long duration : durations) {
            sum += duration.longValue();
        }
        return sum;
    }

    public void report() {
        String message = this.myOperation + " took " + (System.currentTimeMillis() - this.myStartTime) + " ms";
        if (this.myDurationPerRoot.size() > 1) {
            message = message + "\n" + StringUtil.join(this.myDurationPerRoot.entrySet(), (Function)new Function<Map.Entry<VirtualFile, Long>, String>(){

                public String fun(Map.Entry<VirtualFile, Long> entry) {
                    return "    " + entry.getKey().getName() + ": " + entry.getValue() + " ms";
                }
            }, (String)"\n");
        }
        LOG.debug(message);
    }
}

