/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.tables;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.CommitIdByStringCondition;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableModel
extends AbstractTableModel {
    private static final Logger LOG = Logger.getInstance(GraphTableModel.class);
    public static final int ROOT_COLUMN = 0;
    public static final int COMMIT_COLUMN = 1;
    public static final int AUTHOR_COLUMN = 2;
    public static final int DATE_COLUMN = 3;
    private static final int COLUMN_COUNT = 4;
    private static final String[] COLUMN_NAMES = new String[]{"", "Subject", "Author", "Date"};
    @NotNull
    protected final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    protected VisiblePack myDataPack;
    private boolean myMoreRequested;

    public GraphTableModel(@NotNull VisiblePack dataPack, @NotNull VcsLogDataHolder dataHolder, @NotNull VcsLogUiImpl UI2) {
        this.myLogDataHolder = dataHolder;
        this.myUi = UI2;
        this.myDataPack = dataPack;
        this.myDataHolder = dataHolder;
    }

    @Override
    public int getRowCount() {
        return this.myDataPack.getVisibleGraph().getVisibleCommitCount();
    }

    @NotNull
    public VirtualFile getRoot(int rowIndex) {
        int head = (Integer)this.myDataPack.getVisibleGraph().getRowInfo(rowIndex).getOneOfHeads();
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(head);
        if (refs.isEmpty()) {
            LOG.error("No references pointing to head " + this.myDataHolder.getCommitId(head) + " identified for commit at row " + rowIndex, new Attachment[]{new Attachment("details.txt", this.getErrorDetails())});
            return this.myDataPack.getLogProviders().keySet().iterator().next();
        }
        return refs.iterator().next().getRoot();
    }

    @NotNull
    private String getErrorDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("LAST 100 COMMITS:\n");
        List commits = this.myDataPack.getPermanentGraph().getAllCommits();
        for (int i = 0; i < 100 && i < commits.size(); ++i) {
            GraphCommit commit = (GraphCommit)commits.get(i);
            sb.append(String.format("%s -> %s\n", this.myDataHolder.getCommitId((Integer)commit.getId()).getHash().toShortString(), this.getParents((GraphCommit<Integer>)commit)));
        }
        sb.append("\nALL REFS:\n");
        GraphTableModel.printRefs(sb, this.myDataPack.getRefsModel().getAllRefsByRoot());
        return sb.toString();
    }

    @NotNull
    private String getParents(@NotNull GraphCommit<Integer> commit) {
        return StringUtil.join((Collection)commit.getParents(), (Function)new Function<Integer, String>(){

            public String fun(Integer integer) {
                return GraphTableModel.this.myDataHolder.getCommitId(integer).getHash().toShortString();
            }
        }, (String)", ");
    }

    private static void printRefs(@NotNull StringBuilder sb, @NotNull Map<VirtualFile, Set<VcsRef>> refs) {
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry : refs.entrySet()) {
            sb.append("\n\n" + entry.getKey().getName() + ":\n");
            sb.append(StringUtil.join((Collection)entry.getValue(), (Function)new Function<VcsRef, String>(){

                public String fun(@NotNull VcsRef ref) {
                    return ref.getName() + " : " + ref.getCommitHash().toShortString();
                }
            }, (String)"\n"));
        }
    }

    @NotNull
    protected GraphCommitCell getCommitColumnCell(int rowIndex, @Nullable VcsShortCommitDetails details) {
        String message = "";
        List refs = Collections.emptyList();
        if (details != null) {
            message = details.getSubject();
            refs = (List)this.myDataPack.getRefsModel().refsToCommit((Hash)details.getId(), details.getRoot());
        }
        return new GraphCommitCell(message, refs);
    }

    @NotNull
    public Integer getIdAtRow(int row) {
        return (Integer)this.myDataPack.getVisibleGraph().getRowInfo(row).getCommit();
    }

    @NotNull
    public CommitId getCommitIdAtRow(int row) {
        return this.myDataHolder.getCommitId(this.getIdAtRow(row));
    }

    public int getRowOfCommit(@NotNull Hash hash, @NotNull VirtualFile root) {
        final int commitIndex = this.myDataHolder.getCommitIndex(hash, root);
        return ContainerUtil.indexOf(VcsLogUtil.getVisibleCommits(this.myDataPack.getVisibleGraph()), (Condition)new Condition<Integer>(){

            public boolean value(Integer integer) {
                return integer == commitIndex;
            }
        });
    }

    public int getRowOfCommitByPartOfHash(@NotNull String partialHash) {
        final CommitIdByStringCondition hashByString = new CommitIdByStringCondition(partialHash);
        CommitId commitId = this.myDataHolder.getHashMap().findCommitId(new Condition<CommitId>(){

            public boolean value(CommitId commitId) {
                return hashByString.value(commitId) && GraphTableModel.this.getRowOfCommit(commitId.getHash(), commitId.getRoot()) != -1;
            }
        });
        return commitId != null ? this.getRowOfCommit(commitId.getHash(), commitId.getRoot()) : -1;
    }

    @Override
    public final int getColumnCount() {
        return 4;
    }

    public void requestToLoadMore(@NotNull Runnable onLoaded) {
        this.myMoreRequested = true;
        this.myUi.getFilterer().moreCommitsNeeded(onLoaded);
        this.myUi.getTable().setPaintBusy(true);
    }

    @Override
    @NotNull
    public final Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() - 1 && this.canRequestMore()) {
            this.requestToLoadMore(EmptyRunnable.INSTANCE);
        }
        VcsShortCommitDetails data = this.myLogDataHolder.getMiniDetailsGetter().getCommitData(rowIndex, this);
        switch (columnIndex) {
            case 0: {
                return this.getRoot(rowIndex);
            }
            case 1: {
                return this.getCommitColumnCell(rowIndex, data);
            }
            case 2: {
                String authorString = data.getAuthor().getName();
                if (authorString.isEmpty()) {
                    authorString = data.getAuthor().getEmail();
                }
                return authorString + (data.getAuthor().equals(data.getCommitter()) ? "" : "*");
            }
            case 3: {
                if (data.getAuthorTime() < 0L) {
                    return "";
                }
                return DateFormatUtil.formatDateTime((long)data.getAuthorTime());
            }
        }
        throw new IllegalArgumentException("columnIndex is " + columnIndex + " > " + 3);
    }

    public boolean canRequestMore() {
        return !this.myMoreRequested && this.myDataPack.canRequestMore();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return VirtualFile.class;
            }
            case 1: {
                return GraphCommitCell.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("columnIndex is " + column + " > " + 3);
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public void setVisiblePack(@NotNull VisiblePack visiblePack) {
        this.myDataPack = visiblePack;
        this.myMoreRequested = false;
        this.fireTableDataChanged();
    }

    public VisiblePack getVisiblePack() {
        return this.myDataPack;
    }
}

