/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.render.TextLabelPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class VcsRefPainter {
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final TextLabelPainter myTextLabelPainter;

    public VcsRefPainter(@NotNull VcsLogColorManager colorManager, boolean paintRoot) {
        this.myColorManager = colorManager;
        this.myTextLabelPainter = TextLabelPainter.createPainter(paintRoot && colorManager.isMultipleRoots());
    }

    public void paint(@NotNull VcsRef reference, @NotNull Graphics g, int paddingX, int paddingY) {
        this.myTextLabelPainter.paint((Graphics2D)g, reference.getName(), paddingX, paddingY, reference.getType().getBackgroundColor(), (Color)VcsLogColorManagerImpl.getIndicatorColor(this.myColorManager.getRootColor(reference.getRoot())));
    }

    public Rectangle paint(@NotNull String text, @NotNull Graphics g, int paddingX, int paddingY, @NotNull Color color, @NotNull Color flagColor) {
        return this.myTextLabelPainter.paint((Graphics2D)g, text, paddingX, paddingY, color, flagColor);
    }

    public Dimension getSize(@NotNull VcsRef reference, @NotNull JComponent component) {
        return this.getSize(reference.getName(), component);
    }

    public Dimension getSize(@NotNull String referenceName, @NotNull JComponent component) {
        return this.myTextLabelPainter.calculateSize(referenceName, component.getFontMetrics(TextLabelPainter.getFont()));
    }

    public int getHeight(@NotNull JComponent component) {
        return this.myTextLabelPainter.calculateSize((String)"", (FontMetrics)component.getFontMetrics((Font)TextLabelPainter.getFont())).height;
    }
}

