/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.CommittedChangeListForRevision;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogSettings;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.actions.IntelliSortChooserPopupAction;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import com.intellij.vcs.log.ui.frame.BranchesPanel;
import com.intellij.vcs.log.ui.frame.DetailsPanel;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.util.BekUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements DataProvider {
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogUiImpl myUI;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogClassicFilterUi myFilterUi;
    @NotNull
    private final JBLoadingPanel myChangesLoadingPane;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final BranchesPanel myBranchesPanel;
    @NotNull
    private final DetailsPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final RepositoryChangesBrowser myChangesBrowser;

    public MainFrame(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiImpl vcsLogUI, @NotNull Project project2, @NotNull VcsLogSettings settings, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLog log, @NotNull VisiblePack initialDataPack) {
        this.myLogDataHolder = logDataHolder;
        this.myUI = vcsLogUI;
        this.myLog = log;
        this.myFilterUi = new VcsLogClassicFilterUi(this.myUI, logDataHolder, uiProperties, initialDataPack);
        this.myGraphTable = new VcsLogGraphTable(vcsLogUI, logDataHolder, initialDataPack);
        this.myBranchesPanel = new BranchesPanel(logDataHolder, vcsLogUI, initialDataPack.getRefsModel());
        JComponent branchScrollPane = this.myBranchesPanel.createScrollPane();
        branchScrollPane.setVisible(settings.isShowBranchesPanel());
        this.myDetailsPanel = new DetailsPanel(logDataHolder, this.myGraphTable, vcsLogUI.getColorManager(), initialDataPack);
        this.myChangesBrowser = new RepositoryChangesBrowser(project2, null, Collections.emptyList(), null);
        this.myChangesBrowser.getViewer().setScrollPaneBorder(IdeBorderFactory.createBorder((int)2));
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        this.myChangesBrowser.getEditSourceAction().registerCustomShortcutSet(CommonShortcuts.getEditSource(), (JComponent)((Object)this.getGraphTable()));
        MainFrame.setDefaultEmptyText(this.myChangesBrowser);
        this.myChangesLoadingPane = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project2, 300);
        this.myChangesLoadingPane.add((Component)this.myChangesBrowser);
        CommitSelectionListener selectionChangeListener = new CommitSelectionListener(this.myChangesBrowser);
        this.myGraphTable.getSelectionModel().addListSelectionListener(selectionChangeListener);
        this.myGraphTable.getSelectionModel().addListSelectionListener(this.myDetailsPanel);
        this.updateWhenDetailsAreLoaded();
        this.myToolbar = this.createActionsToolbar();
        this.myDetailsSplitter = new OnePixelSplitter(true, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)this.setupScrolledGraph());
        this.setupDetailsSplitter(uiProperties.isShowDetails());
        JPanel toolbars = new JPanel(new BorderLayout());
        toolbars.add((Component)this.myToolbar, "North");
        toolbars.add((Component)branchScrollPane, "Center");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        toolbarsAndTable.add((Component)this.myDetailsSplitter, "Center");
        OnePixelSplitter changesBrowserSplitter = new OnePixelSplitter(false, 0.7f);
        changesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        changesBrowserSplitter.setSecondComponent((JComponent)this.myChangesLoadingPane);
        this.setLayout(new BorderLayout());
        this.add((Component)changesBrowserSplitter);
        Disposer.register((Disposable)logDataHolder, (Disposable)new Disposable((Splitter)changesBrowserSplitter){
            final /* synthetic */ Splitter val$changesBrowserSplitter;
            {
                this.val$changesBrowserSplitter = splitter;
            }

            public void dispose() {
                MainFrame.this.myDetailsSplitter.dispose();
                this.val$changesBrowserSplitter.dispose();
            }
        });
        this.myGraphTable.resetDefaultFocusTraversalKeys();
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyFocusPolicy());
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        this.myFilterUi.updateDataPack(dataPack);
        this.myDetailsPanel.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myBranchesPanel.updateDataPack(dataPack, permGraphChanged);
    }

    private void updateWhenDetailsAreLoaded() {
        this.myLogDataHolder.getMiniDetailsGetter().addDetailsLoadedListener(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.myGraphTable.initColumnSize();
                MainFrame.this.myGraphTable.repaint();
            }
        });
        this.myLogDataHolder.getCommitDetailsGetter().addDetailsLoadedListener(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.myDetailsPanel.valueChanged(null);
            }
        });
        this.myLogDataHolder.getContainingBranchesGetter().setTaskCompletedListener(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.myDetailsPanel.valueChanged(null);
                MainFrame.this.myGraphTable.repaint();
            }
        });
    }

    public void setupDetailsSplitter(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    private JScrollPane setupScrolledGraph() {
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myGraphTable), (int)2);
        this.myGraphTable.viewportSet(scrollPane.getViewport());
        return scrollPane;
    }

    private static void setDefaultEmptyText(ChangesBrowser changesBrowser) {
        changesBrowser.getViewer().setEmptyText("");
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        return this.myGraphTable;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        return this.myFilterUi;
    }

    private JComponent createActionsToolbar() {
        RefreshLogAction refreshLogAction = new RefreshLogAction();
        refreshLogAction.registerShortcutOn(this);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add(ActionManager.getInstance().getAction("Vcs.Log.Toolbar"));
        toolbarGroup.add((AnAction)refreshLogAction);
        DefaultActionGroup mainGroup = new DefaultActionGroup();
        mainGroup.add((AnAction)this.myFilterUi.createActionGroup());
        mainGroup.addSeparator();
        if (BekUtil.isBekEnabled()) {
            if (BekUtil.isLinearBekEnabled()) {
                mainGroup.add((AnAction)new IntelliSortChooserPopupAction());
            } else {
                mainGroup.add(ActionManager.getInstance().getAction("Vcs.Log.IntelliSortChooser"));
            }
        }
        mainGroup.add((AnAction)toolbarGroup);
        ActionToolbar toolbar = this.createActionsToolbar(mainGroup);
        Wrapper textFilter = new Wrapper(this.myFilterUi.createTextFilter());
        textFilter.setVerticalSizeReferent(toolbar.getComponent());
        textFilter.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        ActionToolbar settings = this.createActionsToolbar(new DefaultActionGroup(new AnAction[]{ActionManager.getInstance().getAction("Vcs.Log.QuickSettings")}));
        settings.setReservePlaceAutoPopupIcon(false);
        settings.setLayoutPolicy(0);
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0, fill", "[left]0[left, fill]push[right]"));
        panel.add((Component)textFilter);
        panel.add(toolbar.getComponent());
        panel.add(settings.getComponent());
        return panel;
    }

    @NotNull
    private ActionToolbar createActionsToolbar(@NotNull DefaultActionGroup mainGroup) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ChangesViewToolbar", (ActionGroup)mainGroup, true);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar;
    }

    public JComponent getMainComponent() {
        return this;
    }

    public void setBranchesPanelVisible(boolean visible) {
        JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)this.myBranchesPanel);
        if (scrollPane != null) {
            scrollPane.setVisible(visible);
        } else {
            this.myBranchesPanel.setVisible(visible);
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.myLog;
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.myUI;
        }
        if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER.is(dataId)) {
            return this.myLogDataHolder;
        }
        if (VcsDataKeys.CHANGES.is(dataId) || VcsDataKeys.SELECTED_CHANGES.is(dataId)) {
            return ArrayUtil.toObjectArray(this.myChangesBrowser.getCurrentDisplayedChanges(), Change.class);
        }
        if (VcsDataKeys.CHANGE_LISTS.is(dataId)) {
            List details = this.myLog.getSelectedDetails();
            if (details.size() > 1000) {
                return null;
            }
            return ContainerUtil.map2Array((Collection)details, CommittedChangeListForRevision.class, (Function)new Function<VcsFullCommitDetails, CommittedChangeListForRevision>(){

                public CommittedChangeListForRevision fun(@NotNull VcsFullCommitDetails details) {
                    return new CommittedChangeListForRevision(details.getSubject(), details.getFullMessage(), details.getCommitter().getName(), new Date(details.getCommitTime()), details.getChanges(), (VcsRevisionNumber)MainFrame.convertToRevisionNumber((Hash)details.getId()));
                }
            });
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            List hashes = this.myLog.getSelectedCommits();
            if (hashes.size() > 1000) {
                return null;
            }
            return ArrayUtil.toObjectArray((Collection)ContainerUtil.map((Collection)hashes, (Function)new Function<CommitId, VcsRevisionNumber>(){

                public VcsRevisionNumber fun(CommitId commitId) {
                    return MainFrame.convertToRevisionNumber(commitId.getHash());
                }
            }), VcsRevisionNumber.class);
        }
        if (VcsDataKeys.VCS.is(dataId)) {
            List commits = this.myLog.getSelectedCommits();
            Collection logProviders = this.myLog.getLogProviders();
            if (logProviders.size() == 1) {
                if (!commits.isEmpty()) {
                    return this.myLogDataHolder.getLogProvider(((CommitId)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((List)commits))).getRoot()).getSupportedVcs();
                }
                return null;
            }
            if (commits.size() > 1000) {
                return null;
            }
            Set roots = ContainerUtil.map2Set((Collection)commits, (Function)new Function<CommitId, VirtualFile>(){

                public VirtualFile fun(CommitId commitId) {
                    return commitId.getRoot();
                }
            });
            if (roots.size() == 1) {
                return this.myLogDataHolder.getLogProvider((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))).getSupportedVcs();
            }
        }
        return null;
    }

    @NotNull
    public JComponent getToolbar() {
        return this.myToolbar;
    }

    public boolean areGraphActionsEnabled() {
        return this.myGraphTable.getRowCount() > 0;
    }

    public void onFiltersChange(@NotNull VcsLogFilterCollection filters) {
        this.myBranchesPanel.onFiltersChange(filters);
    }

    @NotNull
    private static TextRevisionNumber convertToRevisionNumber(@NotNull Hash hash) {
        return new TextRevisionNumber(hash.asString(), hash.toShortString());
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)(state ? this.myDetailsPanel : null));
    }

    private class RefreshLogAction
    extends RefreshAction {
        public RefreshLogAction() {
            super("Refresh", "Refresh", AllIcons.Actions.Refresh);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            MainFrame.this.myLogDataHolder.refreshCompletely();
        }

        @Override
        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @Override
        @NotNull
        protected List<Component> getOrderedComponents() {
            return Arrays.asList(new Component[]{MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent()});
        }
    }

    private class CommitSelectionListener
    implements ListSelectionListener {
        private final ChangesBrowser myChangesBrowser;
        private ProgressIndicator myLastRequest;

        public CommitSelectionListener(ChangesBrowser changesBrowser) {
            this.myChangesBrowser = changesBrowser;
        }

        @Override
        public void valueChanged(@Nullable ListSelectionEvent event) {
            if (event != null && event.getValueIsAdjusting()) {
                return;
            }
            if (this.myLastRequest != null) {
                this.myLastRequest.cancel();
            }
            this.myLastRequest = null;
            int rows = MainFrame.this.getGraphTable().getSelectedRowCount();
            if (rows < 1) {
                MainFrame.this.myChangesLoadingPane.stopLoading();
                this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
                this.myChangesBrowser.setChangesToDisplay(Collections.emptyList());
            } else {
                this.myChangesBrowser.setChangesToDisplay(Collections.emptyList());
                MainFrame.setDefaultEmptyText(this.myChangesBrowser);
                MainFrame.this.myChangesLoadingPane.startLoading();
                final EmptyProgressIndicator indicator = new EmptyProgressIndicator();
                this.myLastRequest = indicator;
                MainFrame.this.myLog.requestSelectedDetails((Consumer)new Consumer<List<VcsFullCommitDetails>>(){

                    public void consume(List<VcsFullCommitDetails> detailsList) {
                        if (CommitSelectionListener.this.myLastRequest == indicator && !indicator.isCanceled()) {
                            CommitSelectionListener.this.myLastRequest = null;
                            List<Object> changes = ContainerUtil.newArrayList();
                            List detailsListReversed = ContainerUtil.reverse(detailsList);
                            for (VcsFullCommitDetails details : detailsListReversed) {
                                changes.addAll(details.getChanges());
                            }
                            changes = CommittedChangesTreeBrowser.zipChanges((List<Change>)changes);
                            MainFrame.this.myChangesLoadingPane.stopLoading();
                            CommitSelectionListener.this.myChangesBrowser.setChangesToDisplay(changes);
                        }
                    }
                }, (ProgressIndicator)indicator);
            }
        }
    }
}

