/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsAdapter;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.HtmlTableBuilder;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.render.VcsRefPainter;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Position;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DetailsPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)"Vcs.Log");
    private static final String STANDARD_LAYER = "Standard";
    private static final String MESSAGE_LAYER = "Message";
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final ReferencesPanel myReferencesPanel;
    @NotNull
    private final DataPanel myCommitDetailsPanel;
    @NotNull
    private final MessagePanel myMessagePanel;
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private final JPanel myMainContentPanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private VisiblePack myDataPack;
    @Nullable
    private VcsFullCommitDetails myCurrentCommitDetails;

    DetailsPanel(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogGraphTable graphTable, @NotNull VcsLogColorManager colorManager, @NotNull VisiblePack initialDataPack) {
        this.myLogDataHolder = logDataHolder;
        this.myGraphTable = graphTable;
        this.myColorManager = colorManager;
        this.myDataPack = initialDataPack;
        this.myReferencesPanel = new ReferencesPanel(this.myColorManager);
        this.myCommitDetailsPanel = new DataPanel(logDataHolder.getProject(), logDataHolder.isMultiRoot(), logDataHolder);
        this.myScrollPane = new JBScrollPane(20, 30);
        this.myScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.myMainContentPanel = new JPanel((LayoutManager)new MigLayout("flowy, ins 0, hidemode 3, gapy 0")){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (DetailsPanel.this.myCommitDetailsPanel.isExpanded()) {
                    return size;
                }
                size.width = DetailsPanel.this.myScrollPane.getViewport().getWidth() - 5;
                return size;
            }
        };
        this.myMainContentPanel.setOpaque(false);
        this.myScrollPane.setOpaque(false);
        this.myScrollPane.getViewport().setOpaque(false);
        this.myScrollPane.setViewportView(this.myMainContentPanel);
        this.myScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myScrollPane.setViewportBorder(IdeBorderFactory.createEmptyBorder());
        this.myMainContentPanel.add((Component)this.myReferencesPanel, "");
        this.myMainContentPanel.add((Component)this.myCommitDetailsPanel, "");
        this.myLoadingPanel = new JBLoadingPanel(new BorderLayout(), logDataHolder, 300){

            public Color getBackground() {
                return DetailsPanel.getDetailsBackground();
            }
        };
        this.myLoadingPanel.add((Component)this.myScrollPane);
        this.myMessagePanel = new MessagePanel();
        this.setLayout(new CardLayout());
        this.add((Component)this.myLoadingPanel, STANDARD_LAYER);
        this.add((Component)((Object)this.myMessagePanel), MESSAGE_LAYER);
        this.showMessage("No commits selected");
    }

    @Override
    public Color getBackground() {
        return DetailsPanel.getDetailsBackground();
    }

    private static Color getDetailsBackground() {
        return UIUtil.getTableBackground();
    }

    void updateDataPack(@NotNull VisiblePack dataPack) {
        this.myDataPack = dataPack;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent notUsed) {
        if (notUsed != null && notUsed.getValueIsAdjusting()) {
            return;
        }
        VcsFullCommitDetails newCommitDetails = null;
        int[] rows = this.myGraphTable.getSelectedRows();
        if (rows.length < 1) {
            this.showMessage("No commits selected");
        } else if (rows.length > 1) {
            this.showMessage("Several commits selected");
        } else {
            ((CardLayout)this.getLayout()).show(this, STANDARD_LAYER);
            int row = rows[0];
            GraphTableModel tableModel = (GraphTableModel)this.myGraphTable.getModel();
            VcsFullCommitDetails commitData = (VcsFullCommitDetails)this.myLogDataHolder.getCommitDetailsGetter().getCommitData(row, tableModel);
            if (commitData instanceof LoadingDetails) {
                this.myLoadingPanel.startLoading();
                this.myCommitDetailsPanel.setData(null);
                this.myReferencesPanel.setReferences(Collections.emptyList());
                this.updateDetailsBorder(null);
            } else {
                this.myLoadingPanel.stopLoading();
                this.myCommitDetailsPanel.setData(commitData);
                this.myReferencesPanel.setReferences(this.sortRefs((Hash)commitData.getId(), commitData.getRoot()));
                this.updateDetailsBorder(commitData);
                newCommitDetails = commitData;
            }
            List<String> branches = null;
            if (!(commitData instanceof LoadingDetails)) {
                branches = this.myLogDataHolder.getContainingBranchesGetter().requestContainingBranches(commitData.getRoot(), (Hash)commitData.getId());
            }
            this.myCommitDetailsPanel.setBranches(branches);
            if (!Comparing.equal((Object)this.myCurrentCommitDetails, (Object)newCommitDetails)) {
                this.myCurrentCommitDetails = newCommitDetails;
                this.myScrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    private void updateDetailsBorder(@Nullable VcsFullCommitDetails data) {
        if (data == null || !this.myColorManager.isMultipleRoots()) {
            this.myMainContentPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 0));
        } else {
            JBColor color = VcsLogGraphTable.getRootBackgroundColor(data.getRoot(), this.myColorManager);
            this.myMainContentPanel.setBorder(new CompoundBorder(new MatteBorder(0, 8, 0, 0, (Color)color), new MatteBorder(2, 5, 0, 0, (Color)new JBColor((NotNullProducer)new NotNullProducer<Color>(){

                @NotNull
                public Color produce() {
                    return DetailsPanel.getDetailsBackground();
                }
            }))));
        }
    }

    private void showMessage(String text) {
        this.myLoadingPanel.stopLoading();
        ((CardLayout)this.getLayout()).show(this, MESSAGE_LAYER);
        this.myMessagePanel.setText(text);
    }

    @NotNull
    private List<VcsRef> sortRefs(@NotNull Hash hash, @NotNull VirtualFile root) {
        Collection<VcsRef> refs = this.myDataPack.getRefsModel().refsToCommit(hash, root);
        return ContainerUtil.sorted(refs, (Comparator)this.myLogDataHolder.getLogProvider(root).getReferenceManager().getLabelsOrderComparator());
    }

    private static class MessagePanel
    extends NonOpaquePanel {
        private final JLabel myLabel = new JLabel();

        MessagePanel() {
            super((LayoutManager)new BorderLayout());
            this.myLabel.setForeground(UIUtil.getInactiveTextColor());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(0);
            this.add(this.myLabel);
        }

        void setText(String text) {
            this.myLabel.setText(text);
        }

        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }

    private static class SingleReferencePanel
    extends JPanel {
        @NotNull
        private final VcsRefPainter myRefPainter;
        @NotNull
        private VcsRef myReference;

        SingleReferencePanel(@NotNull VcsRefPainter referencePainter, @NotNull VcsRef reference) {
            this.myRefPainter = referencePainter;
            this.myReference = reference;
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.myRefPainter.paint(this.myReference, g, 0, 0);
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.myRefPainter.getSize(this.myReference, (JComponent)this);
        }
    }

    private static class ReferencesPanel
    extends JPanel {
        @NotNull
        private final VcsRefPainter myReferencePainter;
        @NotNull
        private List<VcsRef> myReferences;

        ReferencesPanel(@NotNull VcsLogColorManager colorManager) {
            super(new FlowLayout(3, 4, 2));
            this.myReferencePainter = new VcsRefPainter(colorManager, false);
            this.myReferences = Collections.emptyList();
            this.setOpaque(false);
        }

        void setReferences(@NotNull List<VcsRef> references) {
            this.removeAll();
            this.myReferences = references;
            for (VcsRef reference : references) {
                this.add(new SingleReferencePanel(this.myReferencePainter, reference));
            }
            this.setVisible(!this.myReferences.isEmpty());
            this.revalidate();
            this.repaint();
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }
    }

    private static class DataPanel
    extends JEditorPane {
        public static final int BRANCHES_LIMIT = 6;
        public static final int BRANCHES_TABLE_COLUMN_COUNT = 3;
        @NotNull
        public static final String LEFT_ALIGN = "left";
        @NotNull
        private static String SHOW_OR_HIDE_BRANCHES = "Show or Hide Branches";
        @NotNull
        private final Project myProject;
        private final boolean myMultiRoot;
        private String myMainText;
        @Nullable
        private List<String> myBranches;
        private boolean myExpanded = false;

        DataPanel(@NotNull Project project2, boolean multiRoot, @NotNull Disposable disposable) {
            super("text/html", "");
            this.myProject = project2;
            this.myMultiRoot = multiRoot;
            this.setEditable(false);
            this.setOpaque(false);
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            EditorColorsManager.getInstance().addEditorColorsListener((EditorColorsListener)new EditorColorsAdapter(){

                public void globalSchemeChange(EditorColorsScheme scheme) {
                    this.update();
                }
            }, disposable);
            DefaultCaret caret = (DefaultCaret)this.getCaret();
            caret.setUpdatePolicy(1);
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && SHOW_OR_HIDE_BRANCHES.equals(e.getDescription())) {
                        myExpanded = !myExpanded;
                        this.update();
                    } else {
                        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
                    }
                }
            });
        }

        void setData(@Nullable VcsFullCommitDetails commit) {
            if (commit == null) {
                this.myMainText = null;
            } else {
                String header = ((Hash)commit.getId()).toShortString() + " " + DataPanel.getAuthorText(commit) + (this.myMultiRoot ? " [" + commit.getRoot().getName() + "]" : "");
                String body = this.getMessageText(commit);
                this.myMainText = header + "<br/>" + body;
            }
            this.update();
        }

        void setBranches(@Nullable List<String> branches) {
            this.myBranches = branches == null ? null : branches;
            this.myExpanded = false;
            this.update();
        }

        private void update() {
            if (this.myMainText == null) {
                this.setText("");
            } else {
                this.setText("<html><head>" + UIUtil.getCssFontDeclaration((Font)EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN)) + "</head><body>" + this.myMainText + "<br/>" + "<br/>" + this.getBranchesText() + "</body></html>");
            }
            this.revalidate();
            this.repaint();
        }

        @NotNull
        private String getBranchesText() {
            if (this.myBranches == null) {
                return "<i>In branches: loading...</i>";
            }
            if (this.myBranches.isEmpty()) {
                return "<i>Not in any branch</i>";
            }
            if (this.myExpanded) {
                int rowCount = (int)Math.ceil((double)this.myBranches.size() / 3.0);
                int[] means = new int[2];
                int[] max = new int[2];
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        int index = rowCount * j + i;
                        if (index >= this.myBranches.size()) continue;
                        int n = j;
                        means[n] = means[n] + this.myBranches.get(index).length();
                        max[j] = Math.max(this.myBranches.get(index).length(), max[j]);
                    }
                }
                int j = 0;
                while (j < 2) {
                    int n = j++;
                    means[n] = means[n] / rowCount;
                }
                HtmlTableBuilder builder = new HtmlTableBuilder();
                for (int i = 0; i < rowCount; ++i) {
                    builder.startRow();
                    if (i == 0) {
                        builder.append("<i>In " + this.myBranches.size() + " branches, </i><a href=\"" + SHOW_OR_HIDE_BRANCHES + "\"><i>hide</i></a>: ");
                    } else {
                        builder.append("");
                    }
                    for (int j2 = 0; j2 < 3; ++j2) {
                        int index = rowCount * j2 + i;
                        if (index >= this.myBranches.size()) {
                            builder.append("");
                            continue;
                        }
                        String branch = this.myBranches.get(index);
                        if (index != this.myBranches.size() - 1) {
                            int space = 0;
                            if (j2 < 2 && branch.length() == max[j2]) {
                                space = Math.max(means[j2] + 20 - max[j2], 5);
                            }
                            builder.append(branch + "," + StringUtil.repeat((String)"&nbsp;", (int)space), LEFT_ALIGN);
                            continue;
                        }
                        builder.append(branch, LEFT_ALIGN);
                    }
                    builder.endRow();
                }
                return builder.build();
            }
            String branchText = this.myBranches.size() <= 6 ? StringUtil.join(this.myBranches, (String)", ") : StringUtil.join((Collection)ContainerUtil.getFirstItems(this.myBranches, (int)6), (String)", ") + ", ... <a href=\"" + SHOW_OR_HIDE_BRANCHES + "\"><i>Show All</i></a>";
            return "<i>In " + this.myBranches.size() + StringUtil.pluralize((String)" branch", (int)this.myBranches.size()) + ":</i> " + branchText;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = Math.max(size.height, 4 * this.getFontMetrics(this.getFont()).getHeight());
            return size;
        }

        private String getMessageText(VcsFullCommitDetails commit) {
            String fullMessage = commit.getFullMessage();
            int separator = fullMessage.indexOf("\n\n");
            String subject = separator > 0 ? fullMessage.substring(0, separator) : fullMessage;
            String description = fullMessage.substring(subject.length());
            return "<b>" + this.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, subject)) + "</b>" + this.escapeMultipleSpaces(IssueLinkHtmlRenderer.formatTextWithLinks(this.myProject, description));
        }

        private String escapeMultipleSpaces(String text) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == ' ') {
                    if (i == text.length() - 1 || text.charAt(i + 1) != ' ') {
                        result.append(' ');
                        continue;
                    }
                    result.append("&nbsp;");
                    continue;
                }
                result.append(text.charAt(i));
            }
            return result.toString();
        }

        private static String getAuthorText(VcsFullCommitDetails commit) {
            long authorTime = commit.getAuthorTime();
            long commitTime = commit.getCommitTime();
            String authorText = commit.getAuthor().getName() + DataPanel.formatDateTime(authorTime);
            if (!commit.getAuthor().equals(commit.getCommitter())) {
                String commitTimeText = authorTime != commitTime ? DataPanel.formatDateTime(commitTime) : "";
                authorText = authorText + " (committed by " + commit.getCommitter().getName() + commitTimeText + ")";
            } else if (authorTime != commitTime) {
                authorText = authorText + " (committed " + DataPanel.formatDateTime(commitTime) + ")";
            }
            return authorText;
        }

        @NotNull
        private static String formatDateTime(long time) {
            return " on " + DateFormatUtil.formatDate((long)time) + " at " + DateFormatUtil.formatTime((long)time);
        }

        @Override
        public String getSelectedText() {
            Document doc = this.getDocument();
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            try {
                Position p0 = doc.createPosition(start);
                Position p1 = doc.createPosition(end);
                StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
                this.getEditorKit().write(sw, doc, p0.getOffset(), p1.getOffset() - p0.getOffset());
                return StringUtil.removeHtmlTags((String)sw.toString());
            }
            catch (BadLocationException e) {
                LOG.warn((Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            return super.getSelectedText();
        }

        @Override
        public Color getBackground() {
            return DetailsPanel.getDetailsBackground();
        }

        public boolean isExpanded() {
            return this.myExpanded;
        }
    }
}

