/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.VirtualFileListCellRenderer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PlatformIcons;
import com.intellij.util.PlusMinus;
import com.intellij.util.TreeNodeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.treeWithCheckedNodes.SelectionManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsStructureChooser
extends DialogWrapper {
    private static final int MAX_FOLDERS = 100;
    public static final Border BORDER = IdeBorderFactory.createBorder((int)3);
    public static final String CAN_NOT_ADD_TEXT = "<html>Selected: <font color=red>(You have added 100 elements. No more is allowed.)</font></html>";
    private static final String VCS_STRUCTURE_CHOOSER_KEY = "git4idea.history.wholeTree.VcsStructureChooser";
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<VirtualFile> myRoots;
    @NotNull
    private final Map<VirtualFile, String> myModulesSet;
    @NotNull
    private final Set<VirtualFile> mySelectedFiles = ContainerUtil.newHashSet();
    @NotNull
    private final SelectionManager mySelectionManager;
    private Tree myTree;

    public VcsStructureChooser(@NotNull Project project2, @NotNull String title, @NotNull Collection<VirtualFile> initialSelection, @NotNull List<VirtualFile> roots) {
        super(project2, true);
        this.setTitle(title);
        this.myProject = project2;
        this.myRoots = roots;
        this.mySelectionManager = new SelectionManager(100, 500, MyNodeConverter.getInstance());
        this.myModulesSet = this.calculateModules(roots);
        this.init();
        this.mySelectionManager.setSelection(initialSelection);
        this.checkEmpty();
    }

    @NotNull
    private Map<VirtualFile, String> calculateModules(@NotNull List<VirtualFile> roots) {
        HashMap result = ContainerUtil.newHashMap();
        final ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        Module[] modules = (Module[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<Module[]>(){

            public Module[] compute() {
                return moduleManager.getModules();
            }
        });
        TreeSet<VirtualFile> checkSet = new TreeSet<VirtualFile>((Comparator<VirtualFile>)FilePathComparator.getInstance());
        checkSet.addAll(roots);
        for (Module module2 : modules) {
            VirtualFile[] files;
            for (VirtualFile file2 : files = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
                VirtualFile floor = checkSet.floor(file2);
                if (floor == null) continue;
                result.put(file2, module2.getName());
            }
        }
        return result;
    }

    @NotNull
    public Collection<VirtualFile> getSelectedFiles() {
        return this.mySelectedFiles;
    }

    private void checkEmpty() {
        this.setOKActionEnabled(!this.mySelectedFiles.isEmpty());
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return VCS_STRUCTURE_CHOOSER_KEY;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected JComponent createCenterPanel() {
        this.myTree = new Tree();
        this.myTree.setBorder(BORDER);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setExpandableItemsEnabled(false);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, true){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (!super.isFileVisible(file2, showHiddenFiles)) {
                    return false;
                }
                if (VcsStructureChooser.this.myRoots.contains(file2)) {
                    return false;
                }
                ChangeListManager changeListManager = ChangeListManager.getInstance((Project)VcsStructureChooser.this.myProject);
                return !changeListManager.isIgnoredFile(file2) && !changeListManager.isUnversioned(file2);
            }
        };
        descriptor.withRoots(new ArrayList<VirtualFile>(this.myRoots)).withShowHiddenFiles(true).withHideIgnored(true);
        final MyCheckboxTreeCellRenderer cellRenderer = new MyCheckboxTreeCellRenderer(this.mySelectionManager, this.myModulesSet, this.myProject, (JTree)this.myTree, this.myRoots);
        FileSystemTreeImpl fileSystemTree = new FileSystemTreeImpl(this.myProject, descriptor, this.myTree, cellRenderer, null, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                DefaultMutableTreeNode lastPathComponent = (DefaultMutableTreeNode)o.getLastPathComponent();
                Object uo = lastPathComponent.getUserObject();
                if (uo instanceof FileNodeDescriptor) {
                    VirtualFile file2 = ((FileNodeDescriptor)((Object)uo)).getElement().getFile();
                    String module2 = (String)VcsStructureChooser.this.myModulesSet.get(file2);
                    if (module2 != null) {
                        return module2;
                    }
                    return file2 == null ? "" : file2.getName();
                }
                return o.toString();
            }
        });
        fileSystemTree.getTreeBuilder().getUi().setNodeDescriptorComparator((Comparator)new Comparator<NodeDescriptor>(){

            @Override
            public int compare(NodeDescriptor o1, NodeDescriptor o2) {
                if (o1 instanceof FileNodeDescriptor && o2 instanceof FileNodeDescriptor) {
                    boolean isDir2;
                    VirtualFile f1 = ((FileNodeDescriptor)o1).getElement().getFile();
                    VirtualFile f2 = ((FileNodeDescriptor)o2).getElement().getFile();
                    boolean isDir1 = f1.isDirectory();
                    if (isDir1 != (isDir2 = f2.isDirectory())) {
                        return isDir1 ? -1 : 1;
                    }
                    return f1.getPath().compareToIgnoreCase(f2.getPath());
                }
                return o1.getIndex() - o2.getIndex();
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                int row = VcsStructureChooser.this.myTree.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return false;
                }
                Object o = VcsStructureChooser.this.myTree.getPathForRow(row).getLastPathComponent();
                if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                    return false;
                }
                Rectangle rowBounds = VcsStructureChooser.this.myTree.getRowBounds(row);
                cellRenderer.setBounds(rowBounds);
                Rectangle checkBounds = cellRenderer.myCheckbox.getBounds();
                checkBounds.setLocation(rowBounds.getLocation());
                if (checkBounds.height == 0) {
                    checkBounds.height = rowBounds.height;
                }
                if (checkBounds.contains(e.getPoint())) {
                    VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                }
                return true;
            }
        }.installOn((Component)this.myTree);
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePath[] paths = VcsStructureChooser.this.myTree.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    for (TreePath path : paths) {
                        if (path == null) continue;
                        Object o = path.getLastPathComponent();
                        if (VcsStructureChooser.this.getTreeRoot() == o || VcsStructureChooser.getFile(o) == null) {
                            return;
                        }
                        VcsStructureChooser.this.mySelectionManager.toggleSelection((DefaultMutableTreeNode)o);
                    }
                    VcsStructureChooser.this.myTree.revalidate();
                    VcsStructureChooser.this.myTree.repaint();
                    e.consume();
                }
            }
        });
        JBPanel panel = new JBPanel((LayoutManager)new BorderLayout());
        panel.add((Component)new JBScrollPane((Component)fileSystemTree.getTree()), (Object)"Center");
        final JLabel selectedLabel = new JLabel("");
        selectedLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        panel.add((Component)selectedLabel, (Object)"South");
        this.mySelectionManager.setSelectionChangeListener(new PlusMinus<VirtualFile>(){

            public void plus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.add(virtualFile);
                this.recalculateErrorText();
            }

            private void recalculateErrorText() {
                VcsStructureChooser.this.checkEmpty();
                if (VcsStructureChooser.this.mySelectionManager.canAddSelection()) {
                    selectedLabel.setText("");
                } else {
                    selectedLabel.setText(VcsStructureChooser.CAN_NOT_ADD_TEXT);
                }
                selectedLabel.revalidate();
            }

            public void minus(VirtualFile virtualFile) {
                VcsStructureChooser.this.mySelectedFiles.remove(virtualFile);
                this.recalculateErrorText();
            }
        });
        panel.setPreferredSize((Dimension)JBUI.size((int)400, (int)300));
        return panel;
    }

    @NotNull
    private DefaultMutableTreeNode getTreeRoot() {
        return (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
    }

    @Nullable
    private static VirtualFile getFile(@NotNull Object node) {
        if (!(((DefaultMutableTreeNode)node).getUserObject() instanceof FileNodeDescriptor)) {
            return null;
        }
        FileNodeDescriptor descriptor = (FileNodeDescriptor)((Object)((DefaultMutableTreeNode)node).getUserObject());
        if (descriptor.getElement().getFile() == null) {
            return null;
        }
        return descriptor.getElement().getFile();
    }

    private static class WithModulesListCellRenderer
    extends VirtualFileListCellRenderer {
        @NotNull
        private final Map<VirtualFile, String> myModules;

        private WithModulesListCellRenderer(@NotNull Project project2, @NotNull Map<VirtualFile, String> modules) {
            super(project2, true);
            this.myModules = modules;
        }

        @Override
        protected String getName(@NotNull FilePath path) {
            String module2 = this.myModules.get(path.getVirtualFile());
            if (module2 != null) {
                return module2;
            }
            return super.getName(path);
        }

        @Override
        protected void renderIcon(@NotNull FilePath path) {
            String module2 = this.myModules.get(path.getVirtualFile());
            if (module2 != null) {
                this.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
            } else if (path.isDirectory()) {
                this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                this.setIcon(path.getFileType().getIcon());
            }
        }

        @Override
        protected void putParentPathImpl(@NotNull Object value, @NotNull String parentPath, @NotNull FilePath self) {
            this.append(self.getPath(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static class MyNodeConverter
    implements Convertor<DefaultMutableTreeNode, VirtualFile> {
        @NotNull
        private static final MyNodeConverter ourInstance = new MyNodeConverter();

        private MyNodeConverter() {
        }

        @NotNull
        public static MyNodeConverter getInstance() {
            return ourInstance;
        }

        public VirtualFile convert(DefaultMutableTreeNode o) {
            return ((FileNodeDescriptor)((Object)o.getUserObject())).getElement().getFile();
        }
    }

    private static class MyCheckboxTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        @NotNull
        private final WithModulesListCellRenderer myTextRenderer;
        @NotNull
        public final JCheckBox myCheckbox;
        @NotNull
        private final SelectionManager mySelectionManager;
        @NotNull
        private final Map<VirtualFile, String> myModulesSet;
        @NotNull
        private final Collection<VirtualFile> myRoots;
        @NotNull
        private final ColoredTreeCellRenderer myColoredRenderer;
        @NotNull
        private final JLabel myEmpty;
        @NotNull
        private final JList myFictive;

        private MyCheckboxTreeCellRenderer(@NotNull SelectionManager selectionManager, @NotNull Map<VirtualFile, String> modulesSet, @NotNull Project project2, @NotNull JTree tree, @NotNull Collection<VirtualFile> roots) {
            super(new BorderLayout());
            this.mySelectionManager = selectionManager;
            this.myModulesSet = modulesSet;
            this.myRoots = roots;
            this.setBackground(tree.getBackground());
            this.myColoredRenderer = new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    this.append(value.toString());
                }
            };
            this.myFictive = new JBList();
            this.myFictive.setBackground(tree.getBackground());
            this.myFictive.setSelectionBackground(UIUtil.getListSelectionBackground());
            this.myFictive.setSelectionForeground(UIUtil.getListSelectionForeground());
            this.myTextRenderer = new WithModulesListCellRenderer(project2, this.myModulesSet){

                @Override
                protected void putParentPath(Object value, FilePath path, FilePath self) {
                    if (myRoots.contains(self.getVirtualFile())) {
                        super.putParentPath(value, path, self);
                    }
                }
            };
            this.myTextRenderer.setBackground(tree.getBackground());
            this.myCheckbox = new JCheckBox();
            this.myCheckbox.setBackground(tree.getBackground());
            this.myEmpty = new JLabel("");
            this.add((Component)this.myCheckbox, "West");
            this.add((Component)((Object)this.myTextRenderer), "Center");
            this.myCheckbox.setVisible(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.invalidate();
            if (value == null) {
                return this.myEmpty;
            }
            VirtualFile file2 = VcsStructureChooser.getFile(value);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (file2 == null) {
                Object uo = node.getUserObject();
                if (uo instanceof String) {
                    this.myColoredRenderer.getTreeCellRendererComponent(tree, (Object)node, selected, expanded, leaf, row, hasFocus);
                    return this.myColoredRenderer;
                }
                return this.myEmpty;
            }
            this.myCheckbox.setVisible(true);
            TreeNodeState state = this.mySelectionManager.getState(node);
            this.myCheckbox.setEnabled(TreeNodeState.CLEAR.equals((Object)state) || TreeNodeState.SELECTED.equals((Object)state));
            this.myCheckbox.setSelected(!TreeNodeState.CLEAR.equals((Object)state));
            this.myCheckbox.setOpaque(false);
            this.myCheckbox.setBackground(null);
            this.setBackground(null);
            this.myTextRenderer.getListCellRendererComponent(this.myFictive, file2, 0, selected, hasFocus);
            this.revalidate();
            return this;
        }
    }
}

