/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDateFilter;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogFilterCollectionImpl;
import com.intellij.vcs.log.impl.VcsLogHashFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.DateFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.StructureFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.UserFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogFileFilter;
import com.intellij.vcs.log.ui.filter.VcsLogTextFilterImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogClassicFilterUi
implements VcsLogFilterUi {
    private static final String VCS_LOG_TEXT_FILTER_HISTORY = "Vcs.Log.Text.Filter.History";
    private static final String HASH_PATTERN = "[a-fA-F0-9]{7,}";
    private static final Logger LOG = Logger.getInstance(VcsLogClassicFilterUi.class);
    @NotNull
    private final VcsLogUiImpl myUi;
    @NotNull
    private final VcsLogDataHolder myLogDataHolder;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private VcsLogDataPack myDataPack;
    @NotNull
    private final BranchFilterModel myBranchFilterModel;
    @NotNull
    private final FilterModel<VcsLogUserFilter> myUserFilterModel;
    @NotNull
    private final FilterModel<VcsLogDateFilter> myDateFilterModel;
    @NotNull
    private final FilterModel<VcsLogFileFilter> myStructureFilterModel;
    @NotNull
    private final TextFilterModel myTextFilterModel;

    public VcsLogClassicFilterUi(@NotNull VcsLogUiImpl ui, @NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogDataPack initialDataPack) {
        this.myUi = ui;
        this.myLogDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
        this.myDataPack = initialDataPack;
        NotNullComputable<VcsLogDataPack> dataPackGetter = new NotNullComputable<VcsLogDataPack>(){

            @NotNull
            public VcsLogDataPack compute() {
                return VcsLogClassicFilterUi.this.myDataPack;
            }
        };
        this.myBranchFilterModel = new BranchFilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myUserFilterModel = new FilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myDateFilterModel = new FilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myStructureFilterModel = new FilterModel((Computable<VcsLogDataPack>)dataPackGetter);
        this.myTextFilterModel = new TextFilterModel(dataPackGetter);
        this.updateUiOnFilterChange();
    }

    private void updateUiOnFilterChange() {
        FilterModel[] models;
        for (FilterModel model : models = new FilterModel[]{this.myBranchFilterModel, this.myUserFilterModel, this.myDateFilterModel, this.myStructureFilterModel, this.myTextFilterModel}) {
            model.addSetFilterListener(new Runnable(){

                @Override
                public void run() {
                    VcsLogClassicFilterUi.this.myUi.applyFiltersAndUpdateUi();
                    VcsLogClassicFilterUi.this.myBranchFilterModel.onStructureFilterChanged(new HashSet<VirtualFile>(VcsLogClassicFilterUi.this.myLogDataHolder.getRoots()), (VcsLogFileFilter)VcsLogClassicFilterUi.this.myStructureFilterModel.getFilter());
                }
            });
        }
    }

    public void updateDataPack(@NotNull VcsLogDataPack dataPack) {
        this.myDataPack = dataPack;
    }

    @NotNull
    public JComponent createTextFilter() {
        final SearchTextFieldWithStoredHistory textFilter = new SearchTextFieldWithStoredHistory(VCS_LOG_TEXT_FILTER_HISTORY){

            protected void onFieldCleared() {
                VcsLogClassicFilterUi.this.myTextFilterModel.setFilter((VcsLogTextFilter)null);
            }
        };
        textFilter.setText(this.myTextFilterModel.getText());
        textFilter.getTextEditor().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                VcsLogClassicFilterUi.this.myTextFilterModel.setFilter(new VcsLogTextFilterImpl(textFilter.getText()));
                textFilter.addCurrentTextToHistory();
            }
        });
        textFilter.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                try {
                    VcsLogClassicFilterUi.this.myTextFilterModel.setUnsavedText(e.getDocument().getText(0, e.getDocument().getLength()));
                }
                catch (BadLocationException ex) {
                    LOG.error((Throwable)ex);
                }
            }
        });
        return textFilter;
    }

    @NotNull
    public ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new BranchFilterPopupComponent(VcsLogClassicFilterUi.this.myUi, VcsLogClassicFilterUi.this.myUiProperties, VcsLogClassicFilterUi.this.myBranchFilterModel).initUi();
            }
        }));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new UserFilterPopupComponent(VcsLogClassicFilterUi.this.myUiProperties, VcsLogClassicFilterUi.this.myLogDataHolder, VcsLogClassicFilterUi.this.myUserFilterModel).initUi();
            }
        }));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new DateFilterPopupComponent(VcsLogClassicFilterUi.this.myDateFilterModel).initUi();
            }
        }));
        actionGroup.add((AnAction)new FilterActionComponent(new Computable<JComponent>(){

            public JComponent compute() {
                return new StructureFilterPopupComponent(VcsLogClassicFilterUi.this.myStructureFilterModel, VcsLogClassicFilterUi.this.myUi.getColorManager()).initUi();
            }
        }));
        return actionGroup;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Pair<VcsLogTextFilter, VcsLogHashFilter> filtersFromText = VcsLogClassicFilterUi.getFiltersFromTextArea((VcsLogTextFilter)this.myTextFilterModel.getFilter());
        return new VcsLogFilterCollectionImpl((VcsLogBranchFilter)this.myBranchFilterModel.getFilter(), this.myUserFilterModel.getFilter(), (VcsLogHashFilter)filtersFromText.second, this.myDateFilterModel.getFilter(), (VcsLogTextFilter)filtersFromText.first, this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getStructureFilter(), this.myStructureFilterModel.getFilter() == null ? null : this.myStructureFilterModel.getFilter().getRootFilter());
    }

    @NotNull
    private static Pair<VcsLogTextFilter, VcsLogHashFilter> getFiltersFromTextArea(@Nullable VcsLogTextFilter filter) {
        VcsLogHashFilterImpl hashFilter;
        VcsLogTextFilterImpl textFilter;
        String word;
        if (filter == null) {
            return Pair.empty();
        }
        String text = filter.getText().trim();
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return Pair.empty();
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        Iterator iterator = StringUtil.split((String)text, (String)" ").iterator();
        while (iterator.hasNext() && !StringUtil.isEmptyOrSpaces((String)(word = (String)iterator.next())) && word.matches(HASH_PATTERN)) {
            hashes.add(word);
        }
        if (!hashes.isEmpty()) {
            textFilter = null;
            hashFilter = new VcsLogHashFilterImpl(hashes);
        } else {
            textFilter = new VcsLogTextFilterImpl(text);
            hashFilter = null;
        }
        return Pair.create((Object)textFilter, (Object)hashFilter);
    }

    public void setFilter(@NotNull VcsLogFilter filter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (filter instanceof VcsLogBranchFilter) {
            this.myBranchFilterModel.setFilter((VcsLogBranchFilter)filter);
            JComponent toolbar = this.myUi.getToolbar();
            toolbar.revalidate();
            toolbar.repaint();
        }
    }

    @NotNull
    public VcsLogUi getLogUi() {
        return this.myUi;
    }

    private static class TextFilterModel
    extends FilterModel<VcsLogTextFilter> {
        @Nullable
        private String myText;

        public TextFilterModel(NotNullComputable<VcsLogDataPack> dataPackProvider) {
            super((Computable<VcsLogDataPack>)dataPackProvider);
        }

        @NotNull
        String getText() {
            if (this.myText != null) {
                return this.myText;
            }
            if (this.getFilter() != null) {
                return ((VcsLogTextFilter)this.getFilter()).getText();
            }
            return "";
        }

        void setUnsavedText(@NotNull String text) {
            this.myText = text;
        }

        @Override
        void setFilter(@Nullable VcsLogTextFilter filter) {
            super.setFilter(filter);
            this.myText = null;
        }
    }

    public static class BranchFilterModel
    extends FilterModel<VcsLogBranchFilter> {
        @Nullable
        private Collection<VirtualFile> myVisibleRoots;

        BranchFilterModel(@NotNull Computable<VcsLogDataPack> provider) {
            super(provider);
        }

        public void onStructureFilterChanged(@NotNull Set<VirtualFile> roots, @Nullable VcsLogFileFilter filter) {
            this.myVisibleRoots = filter == null ? null : VcsLogUtil.getAllVisibleRoots(roots, filter.getRootFilter(), filter.getStructureFilter());
        }

        @Nullable
        public Collection<VirtualFile> getVisibleRoots() {
            return this.myVisibleRoots;
        }
    }

    private static class FilterActionComponent
    extends DumbAwareAction
    implements CustomComponentAction {
        @NotNull
        private final Computable<JComponent> myComponentCreator;

        public FilterActionComponent(@NotNull Computable<JComponent> componentCreator) {
            this.myComponentCreator = componentCreator;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            return (JComponent)this.myComponentCreator.compute();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
        }
    }
}

