/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogUserFilterImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter> {
    @NotNull
    private final VcsLogDataHolder myDataHolder;

    UserFilterPopupComponent(@NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogDataHolder dataHolder, @NotNull FilterModel<VcsLogUserFilter> filterModel) {
        super("User", uiProperties, filterModel);
        this.myDataHolder = dataHolder;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogUserFilter filter) {
        return UserFilterPopupComponent.displayableText(this.getTextValues(filter));
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogUserFilter filter) {
        return UserFilterPopupComponent.tooltip(this.getTextValues(filter));
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createAllAction());
        group.add(this.createSelectMultipleValuesAction());
        if (!this.myDataHolder.getCurrentUser().isEmpty()) {
            group.add(this.createPredefinedValueAction(Collections.singleton("me")));
        }
        group.addAll(this.createRecentItemsActionGroup());
        return group;
    }

    @Override
    @NotNull
    protected Collection<String> getTextValues(@Nullable VcsLogUserFilter filter) {
        if (filter == null) {
            return Collections.emptySet();
        }
        return ContainerUtil.newHashSet(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        return this.myUiProperties.getRecentlyFilteredUserGroups();
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        this.myUiProperties.addRecentlyFilteredUserGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        return ContainerUtil.map(this.myDataHolder.getAllUsers(), (Function)new Function<VcsUser, String>(){

            public String fun(VcsUser user) {
                return user.getName();
            }
        });
    }

    @Override
    @NotNull
    protected VcsLogUserFilter createFilter(@NotNull Collection<String> values) {
        return new VcsLogUserFilterImpl(values, this.myDataHolder.getCurrentUser(), this.myDataHolder.getAllUsers());
    }
}

