/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPopupComponent;
import com.intellij.vcs.log.ui.filter.MultilinePopupBuilder;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MultipleValueFilterPopupComponent<Filter extends VcsLogFilter>
extends FilterPopupComponent<Filter> {
    private static final int MAX_FILTER_VALUE_LENGTH = 30;
    @NotNull
    protected final VcsLogUiProperties myUiProperties;

    MultipleValueFilterPopupComponent(@NotNull String filterName, @NotNull VcsLogUiProperties uiProperties, @NotNull FilterModel<Filter> filterModel) {
        super(filterName, filterModel);
        this.myUiProperties = uiProperties;
    }

    @NotNull
    protected abstract Collection<String> getTextValues(@Nullable Filter var1);

    @NotNull
    protected abstract List<List<String>> getRecentValuesFromSettings();

    protected abstract void rememberValuesInSettings(@NotNull Collection<String> var1);

    @NotNull
    protected abstract List<String> getAllValues();

    @NotNull
    protected abstract Filter createFilter(@NotNull Collection<String> var1);

    @NotNull
    protected ActionGroup createRecentItemsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        List<List<String>> recentlyFiltered = this.getRecentValuesFromSettings();
        if (!recentlyFiltered.isEmpty()) {
            group.addSeparator("Recent");
            for (List<String> recentGroup : recentlyFiltered) {
                if (recentGroup.isEmpty()) continue;
                group.add((AnAction)new PredefinedValueAction(recentGroup));
            }
            group.addSeparator();
        }
        return group;
    }

    @NotNull
    static String displayableText(@NotNull Collection<String> values) {
        if (values.size() == 1) {
            return values.iterator().next();
        }
        return StringUtil.shortenTextWithEllipsis((String)StringUtil.join(values, (String)"|"), (int)30, (int)0, (boolean)true);
    }

    @NotNull
    static String tooltip(@NotNull Collection<String> values) {
        return StringUtil.join(values, (String)", ");
    }

    @NotNull
    protected AnAction createPredefinedValueAction(@NotNull Collection<String> values) {
        return new PredefinedValueAction(values);
    }

    @NotNull
    protected AnAction createSelectMultipleValuesAction() {
        return new SelectMultipleValuesAction();
    }

    protected boolean supportsNegativeValues() {
        return false;
    }

    private class SelectMultipleValuesAction
    extends DumbAwareAction {
        @NotNull
        private final Collection<String> myVariants;

        SelectMultipleValuesAction() {
            super("Select...");
            this.myVariants = MultipleValueFilterPopupComponent.this.getAllValues();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project2 = e.getProject();
            if (project2 == null) {
                return;
            }
            Object filter = MultipleValueFilterPopupComponent.this.myFilterModel.getFilter();
            final MultilinePopupBuilder popupBuilder = new MultilinePopupBuilder(project2, this.myVariants, this.getPopupText(MultipleValueFilterPopupComponent.this.getTextValues(filter)), MultipleValueFilterPopupComponent.this.supportsNegativeValues());
            JBPopup popup = popupBuilder.createPopup();
            popup.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    if (event.isOk()) {
                        Collection<String> selectedValues = popupBuilder.getSelectedValues();
                        if (selectedValues.isEmpty()) {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(null);
                        } else {
                            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(selectedValues));
                            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(selectedValues);
                        }
                    }
                }
            });
            popup.showUnderneathOf((Component)MultipleValueFilterPopupComponent.this);
        }

        @NotNull
        private String getPopupText(@Nullable Collection<String> selectedValues) {
            return selectedValues == null || selectedValues.isEmpty() ? "" : StringUtil.join(selectedValues, (String)"\n");
        }
    }

    protected class PredefinedValueAction
    extends DumbAwareAction {
        @NotNull
        protected final Collection<String> myValues;

        public PredefinedValueAction(Collection<String> values) {
            super(null, MultipleValueFilterPopupComponent.tooltip(values), null);
            this.getTemplatePresentation().setText(MultipleValueFilterPopupComponent.displayableText(values), false);
            this.myValues = values;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            MultipleValueFilterPopupComponent.this.myFilterModel.setFilter(MultipleValueFilterPopupComponent.this.createFilter(this.myValues));
            MultipleValueFilterPopupComponent.this.rememberValuesInSettings(this.myValues);
        }
    }
}

