/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.util.Computable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FilterModel<Filter extends VcsLogFilter> {
    @NotNull
    private final Computable<VcsLogDataPack> myDataPackProvider;
    @NotNull
    private final Collection<Runnable> mySetFilterListeners = ContainerUtil.newArrayList();
    @Nullable
    private Filter myFilter;

    FilterModel(@NotNull Computable<VcsLogDataPack> provider) {
        this.myDataPackProvider = provider;
    }

    void setFilter(@Nullable Filter filter) {
        this.myFilter = filter;
        for (Runnable listener2 : this.mySetFilterListeners) {
            listener2.run();
        }
    }

    @Nullable
    Filter getFilter() {
        return this.myFilter;
    }

    @NotNull
    VcsLogDataPack getDataPack() {
        return (VcsLogDataPack)this.myDataPackProvider.compute();
    }

    void addSetFilterListener(@NotNull Runnable runnable2) {
        this.mySetFilterListeners.add(runnable2);
    }
}

