/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import com.intellij.vcs.log.ui.filter.FlatSpeedSearchPopup;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogClassicFilterUi;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BranchFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogBranchFilter> {
    @NotNull
    private final VcsLogUiImpl myUi;
    private VcsLogClassicFilterUi.BranchFilterModel myBranchFilterModel;

    public BranchFilterPopupComponent(@NotNull VcsLogUiImpl ui, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogClassicFilterUi.BranchFilterModel filterModel) {
        super("Branch", uiProperties, filterModel);
        this.myUi = ui;
        this.myBranchFilterModel = filterModel;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogBranchFilter filter) {
        return BranchFilterPopupComponent.displayableText(this.getTextValues(filter));
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogBranchFilter filter) {
        return BranchFilterPopupComponent.tooltip(this.getTextValues(filter));
    }

    @Override
    @NotNull
    protected VcsLogBranchFilter createFilter(@NotNull Collection<String> values) {
        return VcsLogBranchFilterImpl.fromTextPresentation(values, ContainerUtil.map2Set((Collection)this.myUi.getDataPack().getRefs().getBranches(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef vcsRef) {
                return vcsRef.getName();
            }
        }));
    }

    @Override
    @NotNull
    protected Collection<String> getTextValues(@Nullable VcsLogBranchFilter filter) {
        if (filter == null) {
            return Collections.emptySet();
        }
        return filter.getTextPresentation();
    }

    @Override
    protected boolean supportsNegativeValues() {
        return true;
    }

    @Override
    @NotNull
    protected ListPopup createPopupMenu() {
        return new FlatSpeedSearchPopup(this.createActionGroup(), DataManager.getInstance().getDataContext((Component)this));
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add(this.createAllAction());
        actionGroup.add(this.createSelectMultipleValuesAction());
        actionGroup.add((AnAction)new MyBranchPopupBuilder(this.myFilterModel.getDataPack(), this.myBranchFilterModel.getVisibleRoots(), this.getRecentValuesFromSettings()).build());
        return actionGroup;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        return this.myUiProperties.getRecentlyFilteredBranchGroups();
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        this.myUiProperties.addRecentlyFilteredBranchGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        return ContainerUtil.map((Collection)this.myFilterModel.getDataPack().getRefs().getBranches(), (Function)new Function<VcsRef, String>(){

            public String fun(VcsRef ref) {
                return ref.getName();
            }
        });
    }

    private class MyBranchPopupBuilder
    extends BranchPopupBuilder {
        protected MyBranchPopupBuilder(@Nullable VcsLogDataPack dataPack, @Nullable Collection<VirtualFile> visibleRoots, List<List<String>> recentItems) {
            super(dataPack, visibleRoots, recentItems);
        }

        @Override
        @NotNull
        public AnAction createAction(@NotNull String name) {
            return new MultipleValueFilterPopupComponent.PredefinedValueAction(Collections.singleton(name)){

                @Override
                public void actionPerformed(@NotNull AnActionEvent e) {
                    BranchFilterPopupComponent.this.myFilterModel.setFilter(BranchFilterPopupComponent.this.createFilter((Collection<String>)this.myValues));
                }
            };
        }

        @Override
        protected void createRecentAction(@NotNull DefaultActionGroup actionGroup, @NotNull List<String> recentItem) {
            actionGroup.add((AnAction)new MultipleValueFilterPopupComponent.PredefinedValueAction(BranchFilterPopupComponent.this, recentItem));
        }

        @Override
        @NotNull
        protected AnAction createCollapsedAction(String actionName) {
            return BranchFilterPopupComponent.this.createPredefinedValueAction(Collections.singleton(actionName));
        }
    }
}

