/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import icons.VcsLogIcons;
import org.jetbrains.annotations.NotNull;

public class ShowLongEdgesAction
extends ToggleAction
implements DumbAware {
    public ShowLongEdgesAction() {
        super("Show Long Edges", "Show long branch edges even if commits are invisible in the current view.", VcsLogIcons.ShowHideLongEdges);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        return ui != null && ui.areLongEdgesVisible();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (ui != null) {
            ui.setLongEdgeVisibility(state);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabled(ui != null && ui.areGraphActionsEnabled());
    }
}

