/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightersActionGroup
extends ActionGroup {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        VcsLogUi ui;
        ArrayList actions = ContainerUtil.newArrayList();
        if (e != null && (ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI)) != null) {
            actions.add(new Separator("Highlight"));
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions(VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)e.getProject())) {
                if (!factory.showMenuItem()) continue;
                actions.add(new EnableHighlighterAction(ui, factory));
            }
        }
        return actions.toArray(new AnAction[actions.size()]);
    }

    private static class EnableHighlighterAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final VcsLogHighlighterFactory myFactory;
        @NotNull
        private final VcsLogUi myUi;

        private EnableHighlighterAction(@NotNull VcsLogUi ui, @NotNull VcsLogHighlighterFactory factory) {
            super(factory.getTitle());
            this.myUi = ui;
            this.myFactory = factory;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myUi.isHighlighterEnabled(this.myFactory.getId());
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myUi.setHighlighterEnabled(this.myFactory.getId(), state);
        }
    }
}

