/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurrentBranchHighlighter
implements VcsLogHighlighter {
    private static final JBColor CURRENT_BRANCH_BG = new JBColor(new Color(228, 250, 255), new Color(63, 71, 73));
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUi myLogUi;
    @Nullable
    private String mySingleFilteredBranch;

    public CurrentBranchHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUi logUi) {
        this.myDataHolder = logDataHolder;
        this.myLogUi = logUi;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(@NotNull VcsShortCommitDetails details, boolean isSelected) {
        Condition<CommitId> condition;
        if (isSelected || !this.myLogUi.isHighlighterEnabled("CURRENT_BRANCH")) {
            return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        }
        VcsLogProvider provider = this.myDataHolder.getLogProvider(details.getRoot());
        String currentBranch = provider.getCurrentBranch(details.getRoot());
        if (currentBranch != null && !currentBranch.equals(this.mySingleFilteredBranch) && (condition = this.myDataHolder.getContainingBranchesGetter().getContainedInBranchCondition(currentBranch, details.getRoot())).value((Object)new CommitId((Hash)details.getId(), details.getRoot()))) {
            return VcsCommitStyleFactory.background((Color)CURRENT_BRANCH_BG);
        }
        return VcsLogHighlighter.VcsCommitStyle.DEFAULT;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        VcsLogBranchFilter branchFilter = dataPack.getFilters().getBranchFilter();
        this.mySingleFilteredBranch = branchFilter == null ? null : VcsLogUtil.getSingleFilteredBranch(branchFilter, dataPack.getRefs());
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "CURRENT_BRANCH";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUi logUi) {
            return new CurrentBranchHighlighter(logDataHolder, logUi);
        }

        @Override
        @NotNull
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            return "Current Branch";
        }

        @Override
        public boolean showMenuItem() {
            return true;
        }
    }
}

